// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.mixin.SourceAccessor;

/**
 * An {@link GenericEvent} is published by an {@link Observable} and is consumed
 * by zero to many {@link Observer} instances. The {@link GenericEvent} object
 * describes what the {@link Observable} is publishing. An {@link GenericEvent}
 * provides a source being the origin of the {@link GenericEvent}.
 * 
 * @param <SRC> The type of the source in question.
 */
public interface GenericEvent<SRC> extends SourceAccessor<SRC> {}
