// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;

/**
 * Matches the given group with the group stored in an event's meta data (GROUP
 * EQUAL WITH).
 *
 * @param <E> The matchee type.
 */
public class GroupEqualWithEventMatcher<E extends GenericMetaDataEvent<?, ?>> implements EventMatcher<E> {

	static final String GROUP = "GROUP";

	private String _group;

	/**
	 * Instantiates a new group equal with matcher impl.
	 *
	 * @param aGroup the group
	 */
	public GroupEqualWithEventMatcher( String aGroup ) {
		_group = aGroup;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMatching( E aEvent ) {
		assert (aEvent != null);

		if ( _group != null ) {
			return (_group.equals( aEvent.getMetaData().getGroup() ));
		}
		else if ( aEvent.getMetaData().getGroup() == null ) {
			return true;
		}
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MatcherSchema toSchema() {
		MatcherSchema theSchema = new MatcherSchema( getClass(), "Matches the given group <" + _group + "> with the group stored in an event's meta data (GROUP EQUAL WITH)." );
		theSchema.put( GROUP, _group );
		return theSchema;
	}
}