// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

/**
 * This {@link ObserverDescriptor} describes the {@link Observer}, i.e. in some
 * cases an {@link Observer} requires an {@link EventMatcher} which determines
 * which {@link GenericActionEvent} instances to pass to the {@link Observer}.
 * The {@link ObserverDescriptor} is itself an {@link Observer} calling the
 * {@link EventMatcher} to determine whether to delegate the
 * {@link GenericActionEvent} to contained {@link Observer} or not.
 *
 * @param <E> the element type
 * @param <O> the generic type
 * @param <EM> the generic type
 */
public interface ObserverDescriptor<E extends GenericEvent<?>, O extends Observer<E>, EM extends EventMatcher<E>> extends Observer<E> {

	/**
	 * Returns the {@link Observer} associated with the given
	 * {@link EventMatcher}.
	 *
	 * @return The {@link Observer} as it is being managed by the
	 *         {@link ObserverDescriptor}.
	 */
	O getObserver();

	/**
	 * Returns the {@link EventMatcher} associated with the given
	 * {@link Observer}.
	 * 
	 * @return The {@link EventMatcher} as it is being managed by the
	 *         {@link ObserverDescriptor}.
	 */
	EM getEventMatcher();
}
