// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import java.util.Arrays;

/**
 * Basic implementation of the {@link PayloadEvent} interface.
 * 
 * @param <P> The type of the payload to be carried.
 */
public class PayloadEventImpl<P> extends AbstractPayloadEvent<P, Object> implements PayloadEvent<P> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an event with the given source.
	 *
	 * @param aPayload The payload to be carried by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadEventImpl( P aPayload, Object aSource ) {
		super( aPayload, aSource );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public String toString() {
		P thePayload = getPayload();
		String thePayloadText;
		if ( thePayload != null ) {
			if ( thePayload.getClass().isArray() ) {
				try {
					thePayloadText = Arrays.toString( (Object[]) thePayload );
				}
				catch ( ClassCastException e ) {
					thePayloadText = thePayload.toString();
				}
			}
			else {
				thePayloadText = thePayload.toString();
			}
		}
		else {
			thePayloadText = "null";
		}
		return getClass().getSimpleName() + " [getPayload()=" + thePayloadText + ", getSource()=" + getSource() + "]";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
