// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.mixin.EventMetaData;

/**
 * An {@link PayloadMetaDataActionEvent} provides Meta-Data describing the
 * {@link PayloadMetaDataActionEvent} in more detail and a payload as well as an
 * action.
 * 
 * @param <P> The type of the payload to be carried.
 */
public interface PayloadMetaDataActionEvent<P> extends MetaDataActionEvent, PayloadMetaDataEvent<P>, PayloadActionEvent<P>, GenericActionPayloadMetaDataEvent<Enum<?>, P, EventMetaData, Object> {

	/**
	 * Builder extension for the {@link PayloadMetaDataActionEvent} type.
	 *
	 * @param <P> The type of the payload to be carried.
	 */
	public interface ActionPayloadMetaDataEventBuilder<P> extends PayloadMetaDataActionEvent<P>, GenericActionMetaDataEventBuilder<Enum<?>, EventMetaData, Object, ActionPayloadMetaDataEventBuilder<P>>, GenericActionPayloadMetaDataEventBuilder<Enum<?>, P, EventMetaData, Object, ActionPayloadMetaDataEventBuilder<P>> {

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withPayload( P aPayload ) {
			setPayload( aPayload );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withMetaData( EventMetaData aMetaData ) {
			setMetaData( aMetaData );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withAction( Enum<?> aAction ) {
			setAction( aAction );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withPublisherType( Class<?> aPublisherType ) {
			setPublisherType( aPublisherType );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withChannel( String aChannel ) {
			setChannel( aChannel );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withGroup( String aGroup ) {
			setGroup( aGroup );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withAlias( String aAlias ) {
			setAlias( aAlias );
			return this;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		default ActionPayloadMetaDataEventBuilder<P> withUniversalId( String aUid ) {
			setUniversalId( aUid );
			return this;
		}
	}
}
