// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.mixin.EventMetaData;
import org.refcodes.mixin.EventMetaDataBuilderImpl;
import org.refcodes.mixin.EventMetaDataImpl;
import org.refcodes.observer.AbstractPayloadMetaDataActionEvent.AbstractActionPayloadMetaDataEventBuilder;
import org.refcodes.observer.PayloadMetaDataActionEvent.ActionPayloadMetaDataEventBuilder;

/**
 * Implementation of the {@link ActionPayloadMetaDataEventBuilder} interface for
 * easily creating {@link PayloadMetaDataActionEvent} instances.
 */
public class PayloadMetaDataActionEventBuilderImpl<P> extends AbstractActionPayloadMetaDataEventBuilder<Enum<?>, P, EventMetaData, Object, ActionPayloadMetaDataEventBuilder<P>> implements ActionPayloadMetaDataEventBuilder<P> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an event with predefined values for the according properties
	 * retrieved from the caller's class.
	 * 
	 * @param aAction The action which this represents.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, Class<?> aPublisherType, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl( aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with predefined values for the according properties
	 * retrieved from the caller's class.
	 * 
	 * @param aAction The action which this represents.
	 * @param aChannel The channel name on which the event is receivable.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, String aChannel, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl( aChannel ), aSource );
	}

	/**
	 * Constructs an event with the given values for the according properties.
	 * 
	 * @param aAction The action which this represents.
	 * @param aAlias The alias property.
	 * @param aGroup The group property.
	 * @param aChannel The channel property.
	 * @param aUid The UID (Universal-TID) property.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl( aAlias, aGroup, aChannel, aUid, aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which this represents.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, EventMetaData aEventMetaData, Object aSource ) {
		super( aAction, null, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which this represents.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl(), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which the event represents.
	 * @param aPayload The payload to be carried by the event.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, P aPayload, EventMetaData aEventMetaData, Object aSource ) {
		super( aAction, aPayload, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which the event represents.
	 * @param aPayload The payload to be carried by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Enum<?> aAction, P aPayload, Object aSource ) {
		super( aAction, aPayload, aSource );
	}

	/**
	 * Constructs an event with predefined values for the according properties
	 * retrieved from the caller's class.
	 * 
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Class<?> aPublisherType, Object aSource ) {
		super( new EventMetaDataImpl( aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with predefined values for the according properties
	 * retrieved from the caller's class.
	 * 
	 * @param aChannel The channel name on which the event is receivable.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( String aChannel, Object aSource ) {
		super( new EventMetaDataImpl( aChannel ), aSource );
	}

	/**
	 * Constructs an event with the given values for the according properties.
	 * 
	 * @param aAlias The alias property.
	 * @param aGroup The group property.
	 * @param aChannel The channel property.
	 * @param aUid The UID (Universal-TID) property.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType, Object aSource ) {
		super( new EventMetaDataImpl( aAlias, aGroup, aChannel, aUid, aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( EventMetaData aEventMetaData, Object aSource ) {
		super( aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 *
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( Object aSource ) {
		super( new EventMetaDataImpl(), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aPayload The payload to be carried by the event.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( P aPayload, EventMetaData aEventMetaData, Object aSource ) {
		super( aPayload, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 *
	 * @param aPayload The payload to be carried by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventBuilderImpl( P aPayload, Object aSource ) {
		super( aPayload, aSource );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPublisherType( Class<?> aPublisherType ) {
		if ( _eventMetaData == null ) {
			_eventMetaData = new EventMetaDataBuilderImpl();
		}
		((EventMetaDataBuilder) _eventMetaData).setPublisherType( aPublisherType );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setUniversalId( String aUid ) {
		if ( _eventMetaData == null ) {
			_eventMetaData = new EventMetaDataBuilderImpl();
		}
		((EventMetaDataBuilder) _eventMetaData).setUniversalId( aUid );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAlias( String aAlias ) {
		if ( _eventMetaData == null ) {
			_eventMetaData = new EventMetaDataBuilderImpl();
		}
		((EventMetaDataBuilder) _eventMetaData).setAlias( aAlias );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setGroup( String aGroup ) {
		if ( _eventMetaData == null ) {
			_eventMetaData = new EventMetaDataBuilderImpl();
		}
		((EventMetaDataBuilder) _eventMetaData).setGroup( aGroup );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setChannel( String aChannel ) {
		if ( _eventMetaData == null ) {
			_eventMetaData = new EventMetaDataBuilderImpl();
		}
		((EventMetaDataBuilder) _eventMetaData).setChannel( aChannel );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMetaData( EventMetaData aMetaData ) {
		if ( !(aMetaData instanceof EventMetaDataBuilder) ) {
			aMetaData = new EventMetaDataBuilderImpl( aMetaData );
		}
		_eventMetaData = aMetaData;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public EventMetaDataBuilder getMetaData() {
		return (EventMetaDataBuilder) _eventMetaData;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
