// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.mixin.EventMetaData;
import org.refcodes.mixin.EventMetaDataImpl;

/**
 * Basic implementation of the {@link AbstractPayloadMetaDataActionEvent}.
 *
 * @param <P> The type of the payload to be carried.
 */
public class PayloadMetaDataActionEventImpl<P> extends AbstractPayloadMetaDataActionEvent<Enum<?>, P, EventMetaData, Object> implements PayloadMetaDataActionEvent<P> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an event with predefined values for the according properties
	 * retrieved from the caller's class.
	 * 
	 * @param aAction The action which this represents.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, Class<?> aPublisherType, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl( aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with predefined values for the according properties
	 * retrieved from the caller's class.
	 * 
	 * @param aAction The action which this represents.
	 * @param aChannel The channel name on which the event is receivable.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, String aChannel, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl( aChannel ), aSource );
	}

	/**
	 * Constructs an event with the given values for the according properties.
	 * 
	 * @param aAction The action which this represents.
	 * @param aAlias The alias property.
	 * @param aGroup The group property.
	 * @param aChannel The channel property.
	 * @param aUid The UID (Universal-TID) property.
	 * @param aPublisherType The type of the event publisher.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl( aAlias, aGroup, aChannel, aUid, aPublisherType ), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which this represents.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, EventMetaData aEventMetaData, Object aSource ) {
		super( aAction, null, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which this represents.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, Object aSource ) {
		super( aAction, null, new EventMetaDataImpl(), aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which the event represents.
	 * @param aPayload The payload to be carried by the event.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, P aPayload, EventMetaData aEventMetaData, Object aSource ) {
		super( aAction, aPayload, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aAction The action which the event represents.
	 * @param aPayload The payload to be carried by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( Enum<?> aAction, P aPayload, Object aSource ) {
		super( aAction, aPayload, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 * 
	 * @param aPayload The payload to be carried by the event.
	 * @param aEventMetaData The Meta-Data to by supplied by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( P aPayload, EventMetaData aEventMetaData, Object aSource ) {
		super( aPayload, aEventMetaData, aSource );
	}

	/**
	 * Constructs an event with the given Meta-Data.
	 *
	 * @param aPayload The payload to be carried by the event.
	 * @param aSource The source from which this event originated.
	 */
	public PayloadMetaDataActionEventImpl( P aPayload, Object aSource ) {
		super( aPayload, aSource );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
