// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;

/**
 * Matches by event publisher type (EVENT PUBLISHER TYPE).
 * 
 * @param <E> The matchee type.
 * @param <PT> The publisher type.
 */
public class PublisherIsAssignableFromMatcher<E extends GenericMetaDataEvent<?, ?>, PT extends Object> implements EventMatcher<E> {

	static final String EVENT_PUBLISHER_TYPE = "EVENT_PUBLISHER_TYPE";

	private Class<? extends PT> _eventPublisherType;

	/**
	 * Instantiates a new publisher is assignable from matcher impl.
	 *
	 * @param aEventPublisherType the event publisher type
	 */
	public PublisherIsAssignableFromMatcher( Class<? extends PT> aEventPublisherType ) {
		_eventPublisherType = aEventPublisherType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMatching( E aEvent ) {
		assert (aEvent != null);
		if ( _eventPublisherType != null ) {
			if ( !aEvent.getMetaData().getPublisherType().isAssignableFrom( _eventPublisherType ) ) {
				return false;
			}
		}
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MatcherSchema toSchema() {
		MatcherSchema theSchema = new MatcherSchema( getClass(), "Matches by event publisher type (EVENT PUBLISHER TYPE)." );
		theSchema.put( EVENT_PUBLISHER_TYPE, _eventPublisherType );
		return theSchema;
	}
}