// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;

/**
 * Matches the given universal ID with the universal ID stored in an event's
 * meta data (UNIVERSAL ID EQUAL WITH).
 * 
 * @param <E> THe matchee type.
 */
public class UniversalIdEqualWithEventMatcher<E extends GenericMetaDataEvent<?, ?>> implements EventMatcher<E> {

	static final String UNIVERSAL_ID = "UNIVERSAL_ID";

	private String _universalId;

	/**
	 * Instantiates a new Universal-ID equal with matcher impl.
	 *
	 * @param aUid the Universal-TID
	 */
	public UniversalIdEqualWithEventMatcher( String aUid ) {
		_universalId = aUid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMatching( E aEvent ) {
		assert (aEvent != null);

		if ( _universalId != null ) {
			return (_universalId.equals( aEvent.getMetaData().getUniversalId() ));
		}
		else if ( aEvent.getMetaData().getUniversalId() == null ) {
			return true;
		}
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MatcherSchema toSchema() {
		MatcherSchema theSchema = new MatcherSchema( getClass(), "Matches the given universal ID <" + _universalId + "> with the universal ID stored in an event's meta data (UNIVERSAL ID EQUAL WITH)." );
		theSchema.put( UNIVERSAL_ID, _universalId );
		return theSchema;
	}
}