/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import java.util.HashSet;
import java.util.Set;
import org.refcodes.data.Prefix;
import org.refcodes.properties.AbstractPropertiesBuilderDecorator;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.obfuscation.ObfuscationProperties;

public abstract class AbstractObfuscationPropertiesBuilderDecorator
extends AbstractPropertiesBuilderDecorator<Properties.PropertiesBuilder>
implements ObfuscationProperties.ObfuscationPropertiesBuilder {
    protected String _decryptPrefix = Prefix.DECRYPT.getPrefix();
    protected String _encryptPrefix = Prefix.ENCRYPT.getPrefix();

    public AbstractObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties) {
        super(aProperties);
    }

    public String getEncryptPrefix() {
        return this._encryptPrefix;
    }

    public void setEncryptPrefix(String aEncryptPrefix) {
        this._encryptPrefix = aEncryptPrefix;
    }

    public String getDecryptPrefix() {
        return this._decryptPrefix;
    }

    public void setDecryptPrefix(String aDecryptPrefix) {
        this._decryptPrefix = aDecryptPrefix;
    }

    public String get(Object aKey) {
        String theValue = super.get(aKey);
        if (theValue != null) {
            if (theValue.startsWith(this._encryptPrefix)) {
                theValue = theValue.substring(this._encryptPrefix.length());
            } else if (theValue.startsWith(this._decryptPrefix)) {
                theValue = theValue.substring(this._decryptPrefix.length());
                theValue = this.toDecrypted(theValue);
            }
        }
        return theValue;
    }

    public String put(String aKey, String aValue) {
        if (aValue != null && aValue.startsWith(this._encryptPrefix)) {
            aValue = aValue.substring(this._encryptPrefix.length());
            aValue = this.toEncrypted(aValue);
            aValue = String.valueOf(this._decryptPrefix) + aValue;
        }
        return super.put(aKey, aValue);
    }

    abstract String toEncrypted(String var1);

    abstract String toDecrypted(String var1);

    protected boolean encryptAll() {
        boolean isDirty = false;
        for (String eKey : this.keySet()) {
            String eValue = super.get((Object)eKey);
            if (eValue == null || !eValue.startsWith(this._encryptPrefix)) continue;
            eValue = eValue.substring(this._encryptPrefix.length());
            eValue = this.toEncrypted(eValue);
            super.put(eKey, String.valueOf(this._decryptPrefix) + eValue);
            isDirty = true;
        }
        return isDirty;
    }

    protected Set<String> encryptSet() {
        HashSet<String> theResult = new HashSet<String>();
        for (String eKey : this.keySet()) {
            String eValue = this.get(eKey);
            if (eValue == null || !eValue.startsWith(this._encryptPrefix)) continue;
            theResult.add(eKey);
        }
        return theResult;
    }
}

