/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import org.refcodes.exception.BugException;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.obfuscation.AbstractObfuscationPropertiesBuilderDecorator;
import org.refcodes.properties.ext.obfuscation.ObfuscationProperties;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosTextDecrypter;
import org.refcodes.security.alt.chaos.ChaosTextEncrypter;

public class ObfuscationPropertiesBuilderDecorator
extends AbstractObfuscationPropertiesBuilderDecorator
implements ObfuscationProperties.ObfuscationPropertiesBuilder {
    private ChaosKey _chaosKey;

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties) {
        this(aProperties, SystemContext.HOST.toContextSequence());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aDecryptPrefix, String aEncryptPrefix) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, SystemContext.HOST.toContextSequence());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aDecryptPrefix, String aEncryptPrefix, SystemContext aObfuscationMode) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, aObfuscationMode.toContextSequence());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aDecryptPrefix, String aEncryptPrefix, String aSecret) {
        super(aProperties);
        this._chaosKey = new ChaosKey(aSecret);
        this._decryptPrefix = aDecryptPrefix;
        this._encryptPrefix = aEncryptPrefix;
        this.encryptAll();
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, SystemContext aObfuscationMode) {
        this(aProperties, aObfuscationMode.toContextSequence());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aSecret) {
        super(aProperties);
        this._chaosKey = new ChaosKey(aSecret);
        this.encryptAll();
    }

    @Override
    String toEncrypted(String aValue) {
        try {
            return new ChaosTextEncrypter(this._chaosKey).toEncrypted(aValue);
        }
        catch (EncryptionException e) {
            throw new BugException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypter(this._chaosKey).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException(e.getMessage(), (Throwable)e);
        }
    }
}

