/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.obfuscation.AbstractObfuscationPropertiesDecorator;
import org.refcodes.properties.ext.obfuscation.ObfuscationProperties;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosTextDecrypter;

public class ObfuscationPropertiesDecorator
extends AbstractObfuscationPropertiesDecorator
implements ObfuscationProperties {
    private ChaosKey _chaosKey;

    public ObfuscationPropertiesDecorator(Properties aProperties) {
        this(aProperties, SystemContext.HOST.toContextSequence());
    }

    public ObfuscationPropertiesDecorator(Properties aProperties, String aDecryptPrefix, String aEncryptPrefix) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, SystemContext.HOST.toContextSequence());
    }

    public ObfuscationPropertiesDecorator(Properties aProperties, String aDecryptPrefix, String aEncryptPrefix, SystemContext aObfuscationMode) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, aObfuscationMode.toContextSequence());
    }

    public ObfuscationPropertiesDecorator(Properties aProperties, String aDecryptPrefix, String aEncryptPrefix, String aSecret) {
        super(aProperties);
        int[] theIds = NumericalUtility.toHashCodes((String)aSecret, (int)3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
        this._decryptPrefix = aDecryptPrefix;
        this._encryptPrefix = aEncryptPrefix;
    }

    public ObfuscationPropertiesDecorator(Properties aProperties, SystemContext aObfuscationMode) {
        this(aProperties, aObfuscationMode.toContextSequence());
    }

    public ObfuscationPropertiesDecorator(Properties aProperties, String aSecret) {
        super(aProperties);
        int[] theIds = NumericalUtility.toHashCodes((String)aSecret, (int)3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
    }

    @Override
    String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypter(this._chaosKey).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException(e.getMessage(), (Throwable)e);
        }
    }
}

