/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.observer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.VetoException;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.properties.AbstractPropertiesDecorator;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.observer.ObservableProperties;
import org.refcodes.properties.ext.observer.PropertiesObserver;
import org.refcodes.properties.ext.observer.PropertyCreatedEvent;
import org.refcodes.properties.ext.observer.PropertyCreatedEventImpl;
import org.refcodes.properties.ext.observer.PropertyDeletedEvent;
import org.refcodes.properties.ext.observer.PropertyDeletedEventImpl;
import org.refcodes.properties.ext.observer.PropertyEvent;
import org.refcodes.properties.ext.observer.PropertyEventImpl;
import org.refcodes.properties.ext.observer.PropertyUpdatedEvent;
import org.refcodes.properties.ext.observer.PropertyUpdatedEventImpl;

public abstract class AbstractObservablePropertiesBuilderDecorator<T extends Properties.PropertiesBuilder>
extends AbstractPropertiesDecorator<T>
implements ObservableProperties.ObservablePropertiesBuilder {
    protected PropertiesObservable _propertiesObservable;

    protected AbstractObservablePropertiesBuilderDecorator(T aProperties) {
        super(aProperties);
        this._propertiesObservable = new PropertiesObservable();
    }

    protected AbstractObservablePropertiesBuilderDecorator(T aProperties, ExecutorService aExecutorService, ExecutionStrategy aExecutionStrategy) {
        super(aProperties);
        this._propertiesObservable = new PropertiesObservable(aExecutorService, aExecutionStrategy);
    }

    public String put(String aKey, String aValue) {
        String theBefore;
        PropertyEventImpl theEvent = null;
        if (this.containsKey(aKey)) {
            theBefore = (String)((Properties.PropertiesBuilder)this.getProperties()).put((Object)aKey, (Object)aValue);
            if (theBefore != null && !theBefore.equals(aValue) || theBefore != null != (aValue != null)) {
                theEvent = new PropertyUpdatedEventImpl(this.toNormalizedPath(aKey), aValue, theBefore, (ObservableProperties)this);
            }
        } else {
            theBefore = (String)((Properties.PropertiesBuilder)this.getProperties()).put((Object)aKey, (Object)aValue);
            theEvent = new PropertyCreatedEventImpl(this.toNormalizedPath(aKey), aValue, (ObservableProperties)this);
        }
        if (theEvent != null) {
            try {
                this._propertiesObservable.fireEvent(theEvent);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
        return theBefore;
    }

    public void clear() {
        HashSet theKeys = new HashSet(this.keySet());
        for (String eKey : theKeys) {
            this.remove(eKey);
        }
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return ((Properties.PropertiesBuilder)this.getProperties()).entrySet();
    }

    public void putAll(Map<? extends String, ? extends String> aMap) {
        for (String string : aMap.keySet()) {
            this.put(string, aMap.get(string));
        }
    }

    public String remove(Object aKey) {
        String theKey = aKey != null ? aKey.toString() : null;
        String theValue = (String)((Properties.PropertiesBuilder)this.getProperties()).remove((Object)theKey);
        PropertyDeletedEventImpl theEvent = new PropertyDeletedEventImpl(this.toNormalizedPath(theKey), theValue, (ObservableProperties)this);
        try {
            this._propertiesObservable.fireEvent(theEvent);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
        return theValue;
    }

    public boolean hasObserverSubscription(PropertiesObserver aObserver) {
        return this._propertiesObservable.hasObserverSubscription(aObserver);
    }

    public boolean subscribeObserver(PropertiesObserver aObserver) {
        return this._propertiesObservable.subscribeObserver(aObserver);
    }

    public boolean unsubscribeObserver(PropertiesObserver aObserver) {
        return this._propertiesObservable.unsubscribeObserver(aObserver);
    }

    public void insert(Object aFrom) {
        ((Properties.PropertiesBuilder)this.getProperties()).insert(aFrom);
    }

    public void insertBetween(String aToPath, Object aFrom, String aFromPath) {
        ((Properties.PropertiesBuilder)this.getProperties()).insertBetween(aToPath, aFrom, aFromPath);
    }

    public void insertFrom(Object aFrom, String aFromPath) {
        ((Properties.PropertiesBuilder)this.getProperties()).insertFrom(aFrom, aFromPath);
    }

    public void insertTo(String aToPath, Object aFrom) {
        ((Properties.PropertiesBuilder)this.getProperties()).insertTo(aToPath, aFrom);
    }

    public void merge(Object aFrom) {
        ((Properties.PropertiesBuilder)this.getProperties()).merge(aFrom);
    }

    public void mergeBetween(String aToPath, Object aFrom, String aFromPath) {
        ((Properties.PropertiesBuilder)this.getProperties()).mergeBetween(aToPath, aFrom, aFromPath);
    }

    public void mergeFrom(Object aFrom, String aFromPath) {
        ((Properties.PropertiesBuilder)this.getProperties()).mergeFrom(aFrom, aFromPath);
    }

    public void mergeTo(String aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
    }

    protected void fireEvents(Properties aBefore, Properties aAfter) {
        for (String eKey : aAfter.keySet()) {
            PropertyEventImpl eEvent = null;
            if (!aBefore.containsKey((Object)eKey)) {
                eEvent = new PropertyCreatedEventImpl(this.toNormalizedPath(eKey), this.get(eKey), (ObservableProperties)this);
            } else {
                String eValue;
                String ePreviousValue = (String)aBefore.get((Object)eKey);
                if (!(ePreviousValue == (eValue = this.get(eKey)) || ePreviousValue != null && ePreviousValue.equals(eValue))) {
                    eEvent = ePreviousValue != null && !ePreviousValue.equals(eValue) || ePreviousValue != null != (eValue != null) ? new PropertyUpdatedEventImpl(this.toNormalizedPath(eKey), eValue, ePreviousValue, (ObservableProperties)this) : new PropertyCreatedEventImpl(this.toNormalizedPath(eKey), eValue, (ObservableProperties)this);
                }
            }
            if (eEvent == null) continue;
            try {
                this._propertiesObservable.fireEvent(eEvent);
            }
            catch (VetoException vetoException) {}
        }
    }

    class PropertiesObservable
    extends AbstractObservable<PropertiesObserver, PropertyEvent> {
        private ExecutionStrategy _executionStrategy;

        public PropertiesObservable() {
            this._executionStrategy = ExecutionStrategy.SEQUENTIAL;
        }

        public PropertiesObservable(ExecutorService aExecutorService, ExecutionStrategy aExecutionStrategy) {
            super(aExecutorService);
            this._executionStrategy = aExecutionStrategy != null ? aExecutionStrategy : ExecutionStrategy.SEQUENTIAL;
        }

        public int size() {
            return super.size();
        }

        public boolean isEmpty() {
            return super.isEmpty();
        }

        public void clear() {
            super.clear();
        }

        protected boolean fireEvent(PropertyEvent aEvent) throws VetoException {
            return super.fireEvent((Object)aEvent, this._executionStrategy);
        }

        protected boolean fireEvent(PropertyEvent aEvent, PropertiesObserver aObserver, ExecutionStrategy aExecutionStrategy) throws VetoException {
            if (aEvent instanceof PropertyCreatedEvent) {
                aObserver.onPropertyCreatedEvent((PropertyCreatedEvent)aEvent);
            } else if (aEvent instanceof PropertyUpdatedEvent) {
                aObserver.onPropertyUpdatedEvent((PropertyUpdatedEvent)aEvent);
            } else if (aEvent instanceof PropertyDeletedEvent) {
                aObserver.onPropertyDeletedEvent((PropertyDeletedEvent)aEvent);
            }
            aObserver.onEvent(aEvent);
            return true;
        }
    }
}

