/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.ResourceProperties;

public abstract class AbstractResourcePropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testSaveToLoadFromFlat() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder thePropertiesBuilder = this.toResourcePropertiesBuilder();
        thePropertiesBuilder.put((Object)"firstName", (Object)"Nolan");
        thePropertiesBuilder.put((Object)"lastName", (Object)"Bushnell");
        this.testSaveTo(thePropertiesBuilder);
    }

    @Test
    public void testSaveToLoadFromFlatAndNested() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder thePropertiesBuilder = this.toResourcePropertiesBuilder();
        thePropertiesBuilder.put((Object)"firstName", (Object)"Nolan");
        thePropertiesBuilder.put((Object)"lastName", (Object)"Bushnell");
        thePropertiesBuilder.put((Object)"database/url", (Object)"jdbc://some/db/url");
        thePropertiesBuilder.put((Object)"database/user", (Object)"admin");
        thePropertiesBuilder.put((Object)"database/password", (Object)"secret");
        thePropertiesBuilder.put((Object)"remote/url", (Object)"http://some/remote/connection");
        this.testSaveTo(thePropertiesBuilder);
    }

    @Test
    public void testSaveToLoadFromNested() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder thePropertiesBuilder = this.toResourcePropertiesBuilder();
        thePropertiesBuilder.put((Object)"database/url", (Object)"jdbc://some/db/url");
        thePropertiesBuilder.put((Object)"database/user", (Object)"admin");
        thePropertiesBuilder.put((Object)"database/password", (Object)"secret");
        thePropertiesBuilder.put((Object)"remote/url", (Object)"http://some/remote/connection");
        this.testSaveTo(thePropertiesBuilder);
    }

    protected abstract ResourceProperties.ResourcePropertiesBuilder toResourcePropertiesBuilder();

    protected abstract ResourceProperties toResourceProperties(InputStream var1) throws IOException, ParseException;

    private void testSaveTo(ResourceProperties.ResourcePropertiesBuilder aBuilder) throws IOException, ParseException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        if (IS_LOG_TESTS) {
            if (IS_LOG_TESTS) {
                System.out.println("### PROPERTIES ###");
            }
            for (String eKey : aBuilder.keySet()) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + "=" + (String)aBuilder.get((Object)eKey));
            }
            if (IS_LOG_TESTS) {
                System.out.println("--------------------------------------------------------------------------------");
            }
        }
        aBuilder.saveTo((OutputStream)theOutputStream, "My test properties");
        if (IS_LOG_TESTS) {
            if (IS_LOG_TESTS) {
                System.out.println("### SAVE-TO ###");
            }
            if (IS_LOG_TESTS) {
                System.out.println(theOutputStream.toString());
            }
            if (IS_LOG_TESTS) {
                System.out.println("--------------------------------------------------------------------------------");
            }
        }
        String theJavaPropertiesHack = theOutputStream.toString().replaceAll("\\\\:", ":");
        if (IS_LOG_TESTS) {
            if (IS_LOG_TESTS) {
                System.out.println("### SERIALIZED ###");
            }
            if (IS_LOG_TESTS) {
                System.out.println(aBuilder.toSerialized());
            }
            if (IS_LOG_TESTS) {
                System.out.println("--------------------------------------------------------------------------------");
            }
        }
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theJavaPropertiesHack.getBytes());
        ResourceProperties theProperties = this.toResourceProperties(theInputStream);
        if (IS_LOG_TESTS) {
            if (IS_LOG_TESTS) {
                System.out.println("### LOAD-FROM ###");
            }
            for (String eKey : theProperties.keySet()) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + "=" + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)aBuilder.size(), (int)theProperties.size());
        for (String eKey : aBuilder.keySet()) {
            Assertions.assertEquals((Object)aBuilder.get((Object)eKey), (Object)theProperties.get((Object)eKey));
        }
        if (IS_LOG_TESTS && IS_LOG_TESTS) {
            System.out.println("================================================================================");
        }
    }
}

