/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.NormalizedPropertiesDecorator;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;

public class NormalizedPathPropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testNormalizedProperties() throws IOException {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.withPut(".name.first", "Toshihiro").withPut("name.last", "Nishikado");
        theBuilder.withPut(".atari.name.first", "Nolan").withPut("atari.name.last", "Bushnell");
        theBuilder.withPut(".commodore.name.first", "Jack").withPut("commodore.name.last", "Tramiel");
        if (IS_LOG_TESTS) {
            for (String eKey : theBuilder.keySet()) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theBuilder.get((Object)eKey));
            }
            if (IS_LOG_TESTS) {
                System.out.println("--------------------------------------------------------------------------------");
            }
        }
        NormalizedPropertiesDecorator theProperties = new NormalizedPropertiesDecorator((Properties)theBuilder);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Toshihiro", (Object)theProperties.get((Object)"/name/first"));
        Assertions.assertEquals((Object)"Nishikado", (Object)theProperties.get((Object)"/name/last"));
        Assertions.assertEquals((Object)"Toshihiro", (Object)theProperties.get((Object)"name/first"));
        Assertions.assertEquals((Object)"Nishikado", (Object)theProperties.get((Object)"name/last"));
    }

    @Test
    public void testRetreiveFrom() {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.withPut("name.first", "Toshihiro").withPut("name.last", "Nishikado");
        theBuilder.withPut(".atari.name.first", "Nolan").withPut("atari.name.last", "Bushnell");
        theBuilder.withPut("commodore.name.first", "Jack").withPut("commodore.name.last", "Tramiel");
        NormalizedPropertiesDecorator theProperties = new NormalizedPropertiesDecorator((Properties)theBuilder);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
            if (IS_LOG_TESTS) {
                System.out.println("--------------------------------------------------------------------------------");
            }
        }
        Properties theRetrieved = theProperties.retrieveFrom("/atari");
        if (IS_LOG_TESTS) {
            for (String eKey : theRetrieved.keySet()) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theRetrieved.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theRetrieved.get((Object)"/name/first"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theRetrieved.get((Object)"/name/last"));
        Assertions.assertEquals((Object)"Nolan", (Object)theRetrieved.get((Object)"name/first"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theRetrieved.get((Object)"name/last"));
    }
}

