/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.JavaProperties;
import org.refcodes.properties.JsonProperties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.XmlProperties;
import org.refcodes.properties.YamlProperties;
import org.refcodes.runtime.ConfigLocator;

public class ConfigurationPropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String[][] EXPECTED = new String[][]{{"/com/acme/runtimelogger/logger", "org.refcodes.logger.alt.cli.ConsoleLoggerSingleton"}, {"/com/acme/runtimelogger/logPriority", "INFO"}, {"/com/acme/runtimelogger", "org.refcodes.logger.RuntimeLoggerImpl"}, {"/root/runtimelogger/logger", "org.refcodes.logger.alt.cli.ConsoleLoggerSingleton"}, {"/root/runtimelogger/logPriority", "INFO"}, {"/root/runtimelogger", "org.refcodes.logger.RuntimeLoggerImpl"}};

    @Test
    public void testRuntimeLoggerXml() throws IOException, ParseException {
        XmlProperties theProperties = new XmlProperties("configuration.xml", ConfigLocator.APPLICATION_ALL);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                System.out.println(String.valueOf(eKey) + " = " + (String)theProperties.get((Object)eKey));
            }
        }
        this.verifyResult((ResourceProperties)theProperties);
    }

    @Test
    public void testRuntimeLoggerYaml() throws IOException, ParseException {
        YamlProperties theProperties = new YamlProperties("configuration.yaml", ConfigLocator.APPLICATION_ALL);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                System.out.println(String.valueOf(eKey) + " = " + (String)theProperties.get((Object)eKey));
            }
        }
        this.verifyResult((ResourceProperties)theProperties);
    }

    @Test
    public void testRuntimeLoggerIni() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("configuration.ini", ConfigLocator.APPLICATION_ALL);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                System.out.println(String.valueOf(eKey) + " = " + (String)theProperties.get((Object)eKey));
            }
        }
        this.verifyResult((ResourceProperties)theProperties);
    }

    @Test
    public void testRuntimeLoggerJson() throws IOException, ParseException {
        JsonProperties theProperties = new JsonProperties("configuration.json", ConfigLocator.APPLICATION_ALL);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                System.out.println(String.valueOf(eKey) + " = " + (String)theProperties.get((Object)eKey));
            }
        }
        this.verifyResult((ResourceProperties)theProperties);
    }

    @Test
    public void testRuntimeLoggerProperties() throws IOException, ParseException {
        JavaProperties theProperties = new JavaProperties("configuration.properties", ConfigLocator.APPLICATION_ALL);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                System.out.println(String.valueOf(eKey) + " = " + (String)theProperties.get((Object)eKey));
            }
        }
        this.verifyResult((ResourceProperties)theProperties);
    }

    private void verifyResult(ResourceProperties aProperties) {
        int i = 0;
        while (i < EXPECTED.length) {
            Assertions.assertEquals((Object)EXPECTED[i][1], (Object)aProperties.get((Object)EXPECTED[i][0]));
            ++i;
        }
        Assertions.assertEquals((int)EXPECTED.length, (int)aProperties.size());
    }
}

