/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.TomlPropertiesBuilder;
import org.refcodes.runtime.ConfigLocator;

public class IniPropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String[][] EXPECTED = new String[][]{{"/club/funcodes/runtimelogger/logger", "org.refcodes.logger.alt.cli.ConsoleLoggerSingleton"}, {"/club/funcodes/runtimelogger/logPriority", "INFO"}, {"/club/funcodes/runtimelogger", "org.refcodes.logger.RuntimeLoggerImpl"}, {"/org/refcodes/runtimelogger/logger", "org.refcodes.logger.alt.cli.ConsoleLoggerSingleton"}, {"/org/refcodes/runtimelogger/logPriority", "INFO"}, {"/org/refcodes/runtimelogger", "org.refcodes.logger.RuntimeLoggerImpl"}, {"/root/runtimelogger/logger", "org.refcodes.logger.alt.cli.ConsoleLoggerSingleton"}, {"/root/runtimelogger/logPriority", "INFO"}, {"/root/runtimelogger", "org.refcodes.logger.RuntimeLoggerImpl"}};

    @Test
    public void testIniProperties() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("application.ini", ConfigLocator.APPLICATION_ALL);
        if (IS_LOG_TESTS) {
            for (String eKey : theProperties.keySet()) {
                System.out.println(String.valueOf(eKey) + "=" + (String)theProperties.get((Object)eKey));
            }
        }
        int i = 0;
        while (i < EXPECTED.length) {
            Assertions.assertEquals((Object)EXPECTED[i][1], (Object)theProperties.get((Object)EXPECTED[i][0]));
            ++i;
        }
        Assertions.assertEquals((int)EXPECTED.length, (int)theProperties.size());
    }

    @Test
    public void testEdgeCase() throws IOException, ParseException {
        TomlPropertiesBuilder theBuilder = new TomlPropertiesBuilder("edge_case.ini", ConfigLocator.APPLICATION_ALL);
        ArrayList theKeys = new ArrayList(theBuilder.keySet());
        Collections.sort(theKeys);
        for (String eKey : theKeys) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(String.valueOf(eKey) + " = " + (String)theBuilder.get((Object)eKey));
        }
        Assertions.assertEquals((int)21, (int)theBuilder.size());
    }
}

