/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.FilenameExtension;
import org.refcodes.properties.PolyglotPropertiesBuilder;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotPropertiesBuilderTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testPolyglotPropertiesBuilder1() throws IOException, ParseException {
        String[] theFileEndings;
        String[] stringArray = theFileEndings = new String[]{FilenameExtension.JSON.getFilenameExtension(), FilenameExtension.PROPERTIES.getFilenameExtension(), FilenameExtension.TOML.getFilenameExtension(), FilenameExtension.XML.getFilenameExtension(), FilenameExtension.YAML.getFilenameExtension()};
        int n = theFileEndings.length;
        int n2 = 0;
        while (n2 < n) {
            String eEnding = stringArray[n2];
            PolyglotPropertiesBuilder eProperties = new PolyglotPropertiesBuilder("polyglot" + eEnding, ConfigLocator.APPLICATION_ALL);
            Assertions.assertEquals((Object)eEnding, (Object)eProperties.get((Object)"polyglot/ending"));
            ++n2;
        }
    }

    @Test
    public void testPolyglotPropertiesBuilder2() throws IOException, ParseException {
        PolyglotPropertiesBuilder theProperties = new PolyglotPropertiesBuilder("polyglot", ConfigLocator.APPLICATION_ALL);
        Assertions.assertEquals((Object)".toml", (Object)theProperties.get((Object)"polyglot/ending"));
    }

    @Test
    public void testFileExtenisons() throws IOException, ParseException {
        String eExtension;
        String[] theExpected = new String[]{".toml", ".ini", ".yaml", ".xml", ".json", ".properties"};
        ArrayList<String> theExtensions = new ArrayList<String>();
        PolyglotPropertiesBuilder.PolyglotPropertiesBuilderFactory theFactory = new PolyglotPropertiesBuilder.PolyglotPropertiesBuilderFactory();
        String[] stringArray = theFactory.getFilenameExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            eExtension = stringArray[n2];
            if (IS_LOG_TESTS) {
                System.out.println(eExtension);
            }
            theExtensions.add(eExtension);
            ++n2;
        }
        Assertions.assertEquals((int)theExpected.length, (int)theExtensions.size());
        stringArray = theExpected;
        n = theExpected.length;
        n2 = 0;
        while (n2 < n) {
            eExtension = stringArray[n2];
            Assertions.assertTrue((boolean)theExtensions.contains(eExtension));
            ++n2;
        }
    }

    @Test
    public void testValues() throws IOException, ParseException {
        PolyglotPropertiesBuilder theProperties = new PolyglotPropertiesBuilder("configuration", ConfigLocator.APPLICATION_ALL);
        Collection theValues = theProperties.values();
        if (IS_LOG_TESTS) {
            for (String eValue : theValues) {
                System.out.println(eValue);
            }
        }
        Assertions.assertEquals((int)6, (int)theValues.size());
    }
}

