/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.JavaProperties;
import org.refcodes.properties.JavaPropertiesBuilder;
import org.refcodes.properties.ProfilePropertiesDecorator;
import org.refcodes.properties.ProfilePropertiesProjection;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.ResourceProperties;

public class ProfilePropertiesTest {
    private static final String PROFILE_PROPERTIES_CONFIG = "/profile-properties.config";
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testProfileProperties() throws IOException {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.withPut("name/first", "Toshihiro").withPut("name/last", "Nishikado");
        theBuilder.withPut("atari/name/first", "Nolan").withPut("atari/name/last", "Bushnell");
        theBuilder.withPut("commodore/name/first", "Jack").withPut("commodore/name/last", "Tramiel");
        ProfilePropertiesDecorator theDecorator = new ProfilePropertiesDecorator((Properties.PropertiesBuilder)theBuilder);
        Properties theProfile = theDecorator.toRuntimeProfile(new String[]{"atari"});
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProfile.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                System.out.println(String.valueOf(eKey) + " := " + (String)theProfile.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theProfile.get((Object)"name/first"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProfile.get((Object)"name/last"));
    }

    @Test
    public void testProfileProjection() throws IOException {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.withPut("name/first", "Toshihiro").withPut("name/last", "Nishikado");
        theBuilder.withPut("atari/name/first", "Nolan").withPut("atari/name/last", "Bushnell");
        theBuilder.withPut("commodore/name/first", "Jack").withPut("commodore/name/last", "Tramiel");
        ProfilePropertiesProjection theProjection = new ProfilePropertiesProjection((Properties.PropertiesBuilder)theBuilder, new String[]{"atari"});
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProjection.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + theProjection.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theProjection.get((Object)"name/first"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProjection.get((Object)"name/last"));
    }

    @Test
    public void testProfilePropertiesFromFile() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder theResourceProperties = new JavaPropertiesBuilder().withSeekFrom(this.getClass().getResource(PROFILE_PROPERTIES_CONFIG).getFile());
        ProfilePropertiesDecorator theProfileProperties = new ProfilePropertiesDecorator((Properties)theResourceProperties);
        Properties theProfile = theProfileProperties.toRuntimeProfile();
        Assertions.assertEquals((Object)"someLocalDbUrl", (Object)theProfile.get((Object)"db_url"));
        Assertions.assertEquals((Object)"devops", (Object)theProfile.get((Object)"db_user"));
        Assertions.assertEquals((Object)true, (Object)theProfile.getBoolean("security"));
    }

    @Disabled(value="Depends on internet connectivity :-(")
    @Test
    public void testProfilePropertiesFromUrl() throws IOException, ParseException {
        URL theURL = new URL("https://bitbucket.org/refcodes/refcodes-properties/raw/master/src/test/resources/profile-properties.config");
        JavaProperties theResourceProperties = new JavaProperties(theURL);
        ProfilePropertiesDecorator theProfileProperties = new ProfilePropertiesDecorator((Properties)theResourceProperties);
        Properties theProfile = theProfileProperties.toRuntimeProfile();
        Assertions.assertEquals((Object)"someLocalDbUrl", (Object)theProfile.get((Object)"db_url"));
        Assertions.assertEquals((Object)"devops", (Object)theProfile.get((Object)"db_user"));
        Assertions.assertEquals((Object)true, (Object)theProfile.getBoolean("security"));
    }

    @Test
    public void testProfilePropertiesByProfileFromFile() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder theResourceProperties = new JavaPropertiesBuilder().withSeekFrom(this.getClass().getResource(PROFILE_PROPERTIES_CONFIG).getFile());
        ProfilePropertiesDecorator theProfileProperties = new ProfilePropertiesDecorator((Properties)theResourceProperties);
        Properties theProfile = theProfileProperties.toRuntimeProfile(new String[]{"test"});
        Assertions.assertEquals((Object)"someTestDbUrl", (Object)theProfile.get((Object)"db_url"));
        Assertions.assertEquals((Object)"test", (Object)theProfile.get((Object)"db_user"));
        Assertions.assertEquals((Object)false, (Object)theProfile.getBoolean("security"));
    }
}

