/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.PropertiesBuilderImpl;

public class PropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testAsArray1() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, 5");
        Object[] theArray = theProperties.asArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsArray2() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, 5");
        Object[] theArray = theProperties.asArray("array", ':');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((int)1, (int)theArray.length);
    }

    @Test
    public void testAsArray3() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1,, 3, 4, 5");
        Object[] theArray = theProperties.asArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsBooleanArray1() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"true, false, true, false, true");
        boolean[] theArray = theProperties.asBooleanArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((Object)true, (Object)theArray[0]);
        Assertions.assertEquals((Object)false, (Object)theArray[1]);
        Assertions.assertEquals((Object)true, (Object)theArray[2]);
        Assertions.assertEquals((Object)false, (Object)theArray[3]);
        Assertions.assertEquals((Object)true, (Object)theArray[4]);
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsBooleanArray2() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"true, wahr, true, false, true");
        try {
            theProperties.asBooleanArray("array", ',');
            Assertions.fail((String)"Expecting not to get a boolean array");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testAsIntegerArray1() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, 5");
        int[] theArray = theProperties.asIntArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((int)1, (int)theArray[0]);
        Assertions.assertEquals((int)2, (int)theArray[1]);
        Assertions.assertEquals((int)3, (int)theArray[2]);
        Assertions.assertEquals((int)4, (int)theArray[3]);
        Assertions.assertEquals((int)5, (int)theArray[4]);
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsIntegerArray2() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, five");
        try {
            theProperties.asIntArray("array", ',');
            Assertions.fail((String)"Expecting not to get a boolean array");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testAsByteArray1() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, 5");
        byte[] theArray = theProperties.asByteArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((int)1, (int)theArray[0]);
        Assertions.assertEquals((int)2, (int)theArray[1]);
        Assertions.assertEquals((int)3, (int)theArray[2]);
        Assertions.assertEquals((int)4, (int)theArray[3]);
        Assertions.assertEquals((int)5, (int)theArray[4]);
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsByteArray2() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, five");
        try {
            theProperties.asByteArray("array", ',');
            Assertions.fail((String)"Expecting not to get a boolean array");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testAsCharacterArray1() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, 5");
        char[] theArray = theProperties.asCharArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        Assertions.assertEquals((char)'1', (char)theArray[0]);
        Assertions.assertEquals((char)'2', (char)theArray[1]);
        Assertions.assertEquals((char)'3', (char)theArray[2]);
        Assertions.assertEquals((char)'4', (char)theArray[3]);
        Assertions.assertEquals((char)'5', (char)theArray[4]);
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsCharacterArray2() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1, 2, 3, 4, five");
        try {
            theProperties.asCharArray("array", ',');
            Assertions.fail((String)"Expecting not to get a boolean array");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testAsFloatArray1() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1.1, 2.2, 3.3, 4.4, 5.5");
        float[] theArray = theProperties.asFloatArray("array", ',');
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray));
        }
        MathContext theContext = new MathContext(2);
        Assertions.assertEquals((double)1.1, (double)new BigDecimal(theArray[0], theContext).doubleValue());
        Assertions.assertEquals((double)2.2, (double)new BigDecimal(theArray[1], theContext).doubleValue());
        Assertions.assertEquals((double)3.3, (double)new BigDecimal(theArray[2], theContext).doubleValue());
        Assertions.assertEquals((double)4.4, (double)new BigDecimal(theArray[3], theContext).doubleValue());
        Assertions.assertEquals((double)5.5, (double)new BigDecimal(theArray[4], theContext).doubleValue());
        Assertions.assertEquals((int)5, (int)theArray.length);
    }

    @Test
    public void testAsFloatArray2() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"array", (Object)"1.1, 2.2, 3.3, 4.4, five");
        try {
            theProperties.asFloatArray("array", ',');
            Assertions.fail((String)"Expecting not to get a boolean array");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testPropertyPath() {
        String thePath = "/hallo/welt/";
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        String thePropertyPath = theProperties.toPropertyPath(thePath);
        Assertions.assertEquals((Object)thePath.substring(1, thePath.length() - 1), (Object)thePropertyPath);
    }

    @Test
    public void testToType() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/database/user", (Object)"admin");
        theProperties.put((Object)"/database/password", (Object)"secret");
        theProperties.put((Object)"/database/url", (Object)"my:db/url");
        theProperties.put((Object)"/console/history", (Object)"220");
        theProperties.put((Object)"/console/height", (Object)"25");
        theProperties.put((Object)"/console/ansi", (Object)"true");
        theProperties.put((Object)"/type", (Object)"java.lang.String");
        Configuration theConfig = (Configuration)theProperties.toType(Configuration.class);
        Assertions.assertEquals((Object)"admin", (Object)theConfig.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfig.getDatabase().getPassword());
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig.getDatabase().getUrl());
        Assertions.assertEquals((int)220, (int)theConfig.getConsole().getHistory());
        Assertions.assertEquals((int)25, (int)theConfig.getConsole().getHeight());
        Assertions.assertEquals((Object)true, (Object)theConfig.getConsole().isAnsi());
        Assertions.assertEquals(String.class, theConfig.getType());
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theConfig = (Configuration)theProperties.toType(Configuration.class);
        Assertions.assertEquals((Object)"admin", (Object)theConfig.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfig.getDatabase().getPassword());
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig.getDatabase().getUrl());
        Assertions.assertEquals((int)220, (int)theConfig.getConsole().getHistory());
        Assertions.assertEquals((int)25, (int)theConfig.getConsole().getHeight());
        Assertions.assertEquals((Object)true, (Object)theConfig.getConsole().isAnsi());
        Assertions.assertEquals(String.class, theConfig.getType());
    }

    @Test
    public void testToTypeFragment() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/database/user", (Object)"admin");
        theProperties.put((Object)"/database/password", (Object)"secret");
        theProperties.put((Object)"/database/url", (Object)"my:db/url");
        Configuration theConfig = (Configuration)theProperties.toType(Configuration.class);
        Assertions.assertEquals((Object)"admin", (Object)theConfig.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfig.getDatabase().getPassword());
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig.getDatabase().getUrl());
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theConfig = (Configuration)theProperties.toType(Configuration.class);
        Assertions.assertEquals((Object)"admin", (Object)theConfig.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfig.getDatabase().getPassword());
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig.getDatabase().getUrl());
    }

    @Test
    public void testToInstance() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/database/user", (Object)"admin");
        theProperties.put((Object)"/database/password", (Object)"secret");
        theProperties.put((Object)"/database/url", (Object)"my:db/url");
        theProperties.put((Object)"/console/history", (Object)"220");
        theProperties.put((Object)"/console/height", (Object)"25");
        theProperties.put((Object)"/console/ansi", (Object)"true");
        theProperties.put((Object)"/type", (Object)"java.lang.String");
        Configuration theConfig = new Configuration();
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfig.getDatabase().getPassword());
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig.getDatabase().getUrl());
        Assertions.assertEquals((int)220, (int)theConfig.getConsole().getHistory());
        Assertions.assertEquals((int)25, (int)theConfig.getConsole().getHeight());
        Assertions.assertEquals((Object)true, (Object)theConfig.getConsole().isAnsi());
        Assertions.assertEquals(String.class, theConfig.getType());
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfig.getDatabase().getPassword());
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig.getDatabase().getUrl());
        Assertions.assertEquals((int)220, (int)theConfig.getConsole().getHistory());
        Assertions.assertEquals((int)25, (int)theConfig.getConsole().getHeight());
        Assertions.assertEquals((Object)true, (Object)theConfig.getConsole().isAnsi());
        Assertions.assertEquals(String.class, theConfig.getType());
    }

    @Test
    public void testToArrayType() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/0", (Object)"admin");
        theProperties.put((Object)"/1", (Object)"secret");
        theProperties.put((Object)"/2", (Object)"my:db/url");
        theProperties.put((Object)"/3", (Object)"220");
        theProperties.put((Object)"/4", (Object)"25");
        theProperties.put((Object)"/5", (Object)"true");
        theProperties.put((Object)"/6", (Object)"java.lang.String");
        String[] theConfig = (String[])theProperties.toType(String[].class);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        Assertions.assertEquals((Object)"java.lang.String", (Object)theConfig[6]);
        Assertions.assertEquals((int)theProperties.size(), (int)theConfig.length);
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theConfig = (String[])theProperties.toType(String[].class);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        Assertions.assertEquals((Object)"java.lang.String", (Object)theConfig[6]);
        Assertions.assertEquals((int)theProperties.size(), (int)theConfig.length);
    }

    @Test
    public void testToArrayInstance() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/0", (Object)"admin");
        theProperties.put((Object)"/1", (Object)"secret");
        theProperties.put((Object)"/2", (Object)"my:db/url");
        theProperties.put((Object)"/3", (Object)"220");
        theProperties.put((Object)"/4", (Object)"25");
        theProperties.put((Object)"/5", (Object)"true");
        theProperties.put((Object)"/6", (Object)"java.lang.String");
        String[] theConfig = new String[]{"0", "1", "3", "3", "4", "5", "6"};
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        Assertions.assertEquals((Object)"java.lang.String", (Object)theConfig[6]);
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        Assertions.assertEquals((Object)"java.lang.String", (Object)theConfig[6]);
    }

    @Test
    public void testToSmallerInstance() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/0", (Object)"admin");
        theProperties.put((Object)"/1", (Object)"secret");
        theProperties.put((Object)"/2", (Object)"my:db/url");
        theProperties.put((Object)"/3", (Object)"220");
        theProperties.put((Object)"/4", (Object)"25");
        theProperties.put((Object)"/5", (Object)"true");
        theProperties.put((Object)"/6", (Object)"java.lang.String");
        String[] theConfig = new String[]{"0", "1", "3", "3", "4", "5"};
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
    }

    @Test
    public void testToBiggerArrayInstance() {
        PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
        theProperties.put((Object)"/0", (Object)"admin");
        theProperties.put((Object)"/1", (Object)"secret");
        theProperties.put((Object)"/2", (Object)"my:db/url");
        theProperties.put((Object)"/3", (Object)"220");
        theProperties.put((Object)"/4", (Object)"25");
        theProperties.put((Object)"/5", (Object)"true");
        theProperties.put((Object)"/6", (Object)"java.lang.String");
        String[] theConfig = new String[]{"0", "1", "3", "3", "4", "5", "6", "7"};
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        Assertions.assertEquals((Object)"java.lang.String", (Object)theConfig[6]);
        Assertions.assertEquals((Object)"7", (Object)theConfig[7]);
        theProperties = new PropertiesBuilderImpl((Object)theConfig);
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        theProperties.toInstance((Object)theConfig);
        Assertions.assertEquals((Object)"admin", (Object)theConfig[0]);
        Assertions.assertEquals((Object)"secret", (Object)theConfig[1]);
        Assertions.assertEquals((Object)"my:db/url", (Object)theConfig[2]);
        Assertions.assertEquals((Object)"220", (Object)theConfig[3]);
        Assertions.assertEquals((Object)"25", (Object)theConfig[4]);
        Assertions.assertEquals((Object)"true", (Object)theConfig[5]);
        Assertions.assertEquals((Object)"java.lang.String", (Object)theConfig[6]);
        Assertions.assertEquals((Object)"7", (Object)theConfig[7]);
    }

    @Test
    public void testEdgeCase() {
        try {
            PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl((Object)new File("/"));
            if (IS_LOG_TESTS) {
                ArrayList theKeys = new ArrayList(theProperties.keySet());
                Collections.sort(theKeys);
                for (String eKey : theKeys) {
                    if (!IS_LOG_TESTS) continue;
                    System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
                }
            }
        }
        catch (StackOverflowError e) {
            Assertions.fail((String)"Must not occur!", (Throwable)e);
        }
    }

    public static class Configuration {
        private Class<?> type;
        private DatabaseConnection _database;
        private Console _console;

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public DatabaseConnection getDatabase() {
            return this._database;
        }

        public void setDatabase(DatabaseConnection database) {
            this._database = database;
        }

        public Console getConsole() {
            return this._console;
        }

        public void setConsole(Console console) {
            this._console = console;
        }

        public String toString() {
            return "Configuration [database=" + this._database + ", console=" + this._console + "]";
        }
    }

    public static class Console {
        private int _history;
        private int _height;
        private boolean _ansi2;

        public int getHistory() {
            return this._history;
        }

        public void setHistory(int history) {
            this._history = history;
        }

        public int getHeight() {
            return this._height;
        }

        public void setHeight(int height) {
            this._height = height;
        }

        public boolean isAnsi() {
            return this._ansi2;
        }

        public void setAnsi(boolean ansi) {
            this._ansi2 = ansi;
        }

        public String toString() {
            return "Console [width=" + this._history + ", height=" + this._height + ", ansi=" + this._ansi2 + "]";
        }
    }

    public static class DatabaseConnection {
        private String _user;
        private String _password;
        private String _url;

        public String getUser() {
            return this._user;
        }

        public void setUser(String user) {
            this._user = user;
        }

        public String getPassword() {
            return this._password;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getUrl() {
            return this._url;
        }

        public void setUrl(String url) {
            this._url = url;
        }

        public String toString() {
            return "DatabaseConnection [user=" + this._user + ", password=" + this._password + ", url=" + this._url + "]";
        }
    }
}

