/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.ComplexType;
import org.refcodes.properties.JavaPropertiesBuilder;
import org.refcodes.properties.JsonPropertiesBuilder;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.ResourceProperties;

public class ResourcePropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testJavaProperties() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder theProperties = new JavaPropertiesBuilder().withSeekFrom("application.config");
        if (IS_LOG_TESTS) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TESTS) continue;
                System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"/user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"/user/lastName"));
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"user/lastName"));
    }

    @Test
    public void testComplexType() throws IOException, ParseException {
        JsonPropertiesBuilder theJsonProperties = new JsonPropertiesBuilder(this.getClass(), "/ComplexType.json");
        System.out.println("JSON");
        for (String eKey : theJsonProperties.sortedKeys()) {
            System.out.println(String.valueOf(eKey) + " = " + (String)theJsonProperties.get((Object)eKey));
        }
        ComplexType theRequest = (ComplexType)theJsonProperties.toType(ComplexType.class);
        PropertiesBuilderImpl theTypePorperties = new PropertiesBuilderImpl((Object)theRequest);
        System.out.println("\nTYPE");
        for (String eKey : theTypePorperties.sortedKeys()) {
            System.out.println(String.valueOf(eKey) + " = " + (String)theTypePorperties.get((Object)eKey));
        }
        Assertions.assertEquals((int)theJsonProperties.size(), (int)theTypePorperties.size());
    }
}

