/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.properties.AbstractResourcePropertiesTest;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.XmlProperties;
import org.refcodes.properties.XmlPropertiesBuilder;

public class XmlPropertiesTest
extends AbstractResourcePropertiesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void tesVerifyEdgeCase() throws MarshalException, UnmarshalException, IOException, ParseException {
        XmlPropertiesBuilder theDataStructure = new XmlPropertiesBuilder();
        theDataStructure.put("aaa/aaa_111", (Object)"aaa_111");
        theDataStructure.put("aaa/aaa_222", (Object)"aaa_222");
        theDataStructure.put("aaa/aaa_333", (Object)"aaa_333");
        theDataStructure.put("bbb/bbb_111", (Object)"bbb_111");
        theDataStructure.put("bbb/bbb_222", (Object)"bbb_222");
        theDataStructure.put("bbb/bbb_333", (Object)"bbb_333");
        theDataStructure.put("ccc/ccc_111", (Object)"ccc_111");
        theDataStructure.put("ccc/ccc_222", (Object)"ccc_222");
        theDataStructure.put("ccc/ccc_333", (Object)"ccc_333");
        String theMarshaled = theDataStructure.toSerialized();
        if (IS_LOG_TESTS) {
            System.out.println(theMarshaled);
        }
        XmlPropertiesBuilder theUnmarshaled = new XmlPropertiesBuilder();
        ByteArrayInputStream theUnmarshaledStream = new ByteArrayInputStream(theMarshaled.getBytes(StandardCharsets.UTF_8));
        theUnmarshaled.loadFrom((InputStream)theUnmarshaledStream);
        Assertions.assertEquals((int)theDataStructure.size(), (int)theUnmarshaled.size());
        for (String eKey : theDataStructure.keySet()) {
            Assertions.assertEquals((Object)theDataStructure.get((Object)eKey), (Object)theUnmarshaled.get((Object)eKey));
        }
    }

    @Override
    protected ResourceProperties.ResourcePropertiesBuilder toResourcePropertiesBuilder() {
        return new XmlPropertiesBuilder();
    }

    @Override
    protected ResourceProperties toResourceProperties(InputStream aInputStream) throws IOException, ParseException {
        return new XmlProperties(aInputStream);
    }
}

