// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.properties;

import static org.junit.jupiter.api.Assertions.*;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.junit.jupiter.api.Test;
import org.refcodes.data.FilenameExtension;
import org.refcodes.properties.PolyglotPropertiesBuilder.PolyglotPropertiesBuilderFactory;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotPropertiesBuilderTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean( "log.test" );

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testPolyglotPropertiesBuilder1() throws IOException, ParseException {
		PolyglotPropertiesBuilder eProperties;
		final String[] theFileEndings = new String[] { FilenameExtension.JSON.getFilenameSuffix(), FilenameExtension.PROPERTIES.getFilenameSuffix(), FilenameExtension.TOML.getFilenameSuffix(), FilenameExtension.XML.getFilenameSuffix(), FilenameExtension.YAML.getFilenameSuffix() };
		for ( String eEnding : theFileEndings ) {
			eProperties = new PolyglotPropertiesBuilder( "polyglot" + eEnding, ConfigLocator.APPLICATION_ALL );
			assertEquals( eEnding, eProperties.get( "polyglot/ending" ) );
		}
	}

	/**
	 * We assume the first factory completing the name with its the extension
	 * wins. The TOML factory is added first.
	 */
	@Test
	public void testPolyglotPropertiesBuilder2() throws IOException, ParseException {
		final PolyglotPropertiesBuilder theProperties = new PolyglotPropertiesBuilder( "polyglot", ConfigLocator.APPLICATION_ALL );
		assertEquals( ".toml", theProperties.get( "polyglot/ending" ) );
	}

	/**
	 * We assume the first factory completing the name with its the extension
	 * wins. The TOML factory is added first.
	 */
	@Test
	public void testFileExtenisons() throws IOException, ParseException {
		final String[] theExpected = new String[] { ".toml", ".ini", ".yaml", ".xml", ".json", ".properties" };
		final List<String> theExtensions = new ArrayList<>();
		final PolyglotPropertiesBuilderFactory theFactory = new PolyglotPropertiesBuilderFactory();
		for ( String eExtension : theFactory.getFilenameSuffixes() ) {
			if ( IS_LOG_TEST_ENABLED ) {
				System.out.println( eExtension );
			}
			theExtensions.add( eExtension );
		}
		assertEquals( theExpected.length, theExtensions.size() );
		for ( String eExtension : theExpected ) {
			assertTrue( theExtensions.contains( eExtension ) );
		}
	}

	@Test
	public void testValues() throws IOException, ParseException {
		final PolyglotPropertiesBuilder theProperties = new PolyglotPropertiesBuilder( "configuration", ConfigLocator.APPLICATION_ALL );
		final Collection<String> theValues = theProperties.values();
		if ( IS_LOG_TEST_ENABLED ) {
			for ( String eValue : theValues ) {
				System.out.println( eValue );
			}
		}
		assertEquals( 6, theValues.size() );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
