/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.FilenameExtension;
import org.refcodes.properties.PolyglotProperties;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotPropertiesTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testPolyglotProperties1() throws IOException, ParseException {
        String[] theFileEndings;
        for (String eEnding : theFileEndings = new String[]{FilenameExtension.JSON.getFilenameSuffix(), FilenameExtension.PROPERTIES.getFilenameSuffix(), FilenameExtension.TOML.getFilenameSuffix(), FilenameExtension.XML.getFilenameSuffix(), FilenameExtension.YAML.getFilenameSuffix()}) {
            PolyglotProperties eProperties = new PolyglotProperties("polyglot" + eEnding, ConfigLocator.APPLICATION_ALL);
            Assertions.assertEquals((Object)eEnding, (Object)eProperties.get((Object)"polyglot/ending"));
        }
    }

    @Test
    public void testPolyglotProperties2() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("polyglot", ConfigLocator.APPLICATION_ALL);
        Assertions.assertEquals((Object)".toml", (Object)theProperties.get((Object)"polyglot/ending"));
    }

    @Test
    public void testFileExtenisons() throws IOException, ParseException {
        String[] theExpected = new String[]{".toml", ".ini", ".yaml", ".xml", ".json", ".properties"};
        ArrayList<String> theExtensions = new ArrayList<String>();
        PolyglotProperties.PolyglotPropertiesFactory theFactory = new PolyglotProperties.PolyglotPropertiesFactory();
        for (String eExtension : theFactory.getFilenameSuffixes()) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(eExtension);
            }
            theExtensions.add(eExtension);
        }
        Assertions.assertEquals((int)theExpected.length, (int)theExtensions.size());
        for (String eExtension : theExpected) {
            Assertions.assertTrue((boolean)theExtensions.contains(eExtension));
        }
    }

    @Test
    public void testValues() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("configuration", ConfigLocator.APPLICATION_ALL);
        Collection theValues = theProperties.values();
        if (IS_LOG_TEST_ENABLED) {
            for (String eValue : theValues) {
                System.out.println(eValue);
            }
        }
        Assertions.assertEquals((int)6, (int)theValues.size());
    }
}

