/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.ComplexType;
import org.refcodes.properties.JavaPropertiesBuilder;
import org.refcodes.properties.JsonPropertiesBuilder;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.ResourceProperties;

public class ResourcePropertiesTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testJavaProperties() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder theProperties = new JavaPropertiesBuilder().withSeekFrom("application.config");
        if (IS_LOG_TEST_ENABLED) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!IS_LOG_TEST_ENABLED) continue;
                System.out.println(eKey + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"/user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"/user/lastName"));
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"user/lastName"));
    }

    @Test
    public void testComplexType() throws IOException, ParseException {
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("JSON");
        }
        JsonPropertiesBuilder theJsonProperties = new JsonPropertiesBuilder(this.getClass(), "/ComplexType.json");
        if (IS_LOG_TEST_ENABLED) {
            for (String eKey : theJsonProperties.sortedKeys()) {
                System.out.println(eKey + " = " + (String)theJsonProperties.get((Object)eKey));
            }
        }
        ComplexType theJsonType = (ComplexType)theJsonProperties.toType(ComplexType.class);
        Assertions.assertEquals((Object)theJsonType.getLocale(), (Object)Locale.GERMANY);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("\nTYPE");
        }
        PropertiesBuilderImpl theTypeProperties = new PropertiesBuilderImpl((Object)theJsonType);
        if (IS_LOG_TEST_ENABLED) {
            for (String eKey : theTypeProperties.sortedKeys()) {
                System.out.println(eKey + " = " + (String)theTypeProperties.get((Object)eKey));
            }
        }
        ComplexType theTypeType = (ComplexType)theTypeProperties.toType(ComplexType.class);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("theJsonType.getLocale() = " + theJsonType.getLocale());
            System.out.println("theTypeType.getLocale() = " + theTypeType.getLocale());
        }
        Assertions.assertEquals((int)theJsonProperties.size(), (int)theTypeProperties.size());
        Assertions.assertEquals((Object)theJsonType.getLocale(), (Object)theTypeType.getLocale());
        Assertions.assertEquals((Object)theJsonType.getTimestamp(), (Object)theTypeType.getTimestamp());
        Assertions.assertEquals((Object)theJsonType.getLocalTimestamp(), (Object)theTypeType.getLocalTimestamp());
    }
}

