/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.FilenameExtension;
import org.refcodes.properties.PolyglotProperties;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.SystemProperty;

public class PolyglotPropertiesTest {
    @Test
    public void testPolyglotProperties1() throws IOException, ParseException {
        String[] theFileEndings;
        for (String eEnding : theFileEndings = new String[]{FilenameExtension.JSON.getFilenameSuffix(), FilenameExtension.PROPERTIES.getFilenameSuffix(), FilenameExtension.TOML.getFilenameSuffix(), FilenameExtension.XML.getFilenameSuffix(), FilenameExtension.YAML.getFilenameSuffix()}) {
            PolyglotProperties eProperties = new PolyglotProperties("polyglot" + eEnding, ConfigLocator.APPLICATION_ALL);
            Assertions.assertEquals((Object)eEnding, (Object)eProperties.get((Object)"polyglot/ending"));
        }
    }

    @Test
    public void testPolyglotProperties2() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("polyglot", ConfigLocator.APPLICATION_ALL);
        Assertions.assertEquals((Object)".toml", (Object)theProperties.get((Object)"polyglot/ending"));
    }

    @Test
    public void testFileExtenisons() throws IOException, ParseException {
        String[] theExpected = new String[]{".toml", ".ini", ".yaml", ".xml", ".json", ".properties"};
        ArrayList<String> theExtensions = new ArrayList<String>();
        PolyglotProperties.PolyglotPropertiesFactory theFactory = new PolyglotProperties.PolyglotPropertiesFactory();
        for (String eExtension : theFactory.getFilenameSuffixes()) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(eExtension);
            }
            theExtensions.add(eExtension);
        }
        Assertions.assertEquals((int)theExpected.length, (int)theExtensions.size());
        for (String eExtension : theExpected) {
            Assertions.assertTrue((boolean)theExtensions.contains(eExtension));
        }
    }

    @Test
    public void testValues() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("configuration", ConfigLocator.APPLICATION_ALL);
        Collection theValues = theProperties.values();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eValue : theValues) {
                System.out.println(eValue);
            }
        }
        Assertions.assertEquals((int)6, (int)theValues.size());
    }

    @Test
    public void testDocumentRootPreserve() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyEnvelope.xml", ConfigLocator.APPLICATION_ALL, true);
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/envelope/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/envelope/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/envelope/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/envelope/identity/lastName"));
    }

    @Test
    public void testDocumentRootSkip() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyEnvelope.xml", ConfigLocator.APPLICATION_ALL, false);
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter1() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyDelimiter1.ini", ConfigLocator.APPLICATION_ALL, new char[]{'/'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter1Other() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyDelimiter1.ini", ConfigLocator.APPLICATION_ALL, new char[]{'|'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter2() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyDelimiter2.ini", ConfigLocator.APPLICATION_ALL, new char[]{'\\'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter2Other() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyDelimiter2.ini", ConfigLocator.APPLICATION_ALL, new char[]{'/'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity\\firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity\\lastName"));
    }

    @Test
    public void testDelimiter3() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyDelimiter3.ini", ConfigLocator.APPLICATION_ALL, new char[]{'\\', '|'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter3Other() throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties("donaBaileyDelimiter3.ini", ConfigLocator.APPLICATION_ALL, new char[]{'/'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/\\game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/|identity\\firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/\\identity|lastName"));
    }
}

