/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesSugar;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ScheduledResourceProperties;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.struct.Property;

public class PropertiesSugarTest {
    @Test
    public void testPropertiesPrecedence() {
        Properties theProperties = PropertiesSugar.toPrecedence((Properties[])new Properties[]{PropertiesSugar.fromProperties((Property[])new Property[]{PropertiesSugar.toProperty((String)"/user/firstName", (String)"Nolan"), PropertiesSugar.toProperty((String)"/user/lastName", (String)"Bushnell")}), PropertiesSugar.fromProperties((Property[])new Property[]{PropertiesSugar.toProperty((String)"/user/firstName", (String)"Jack"), PropertiesSugar.toProperty((String)"/user/lastName", (String)"Tramiel")})});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theProperties.keySet()) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
                System.out.println(eKey + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"/user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"/user/lastName"));
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"user/lastName"));
    }

    @Test
    public void testJavaProperties() throws IOException, ParseException {
        Properties theProperties = PropertiesSugar.toNormalized((Properties)PropertiesSugar.seekFromJavaProperties((String)"application.properties"));
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theProperties.keySet()) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
                System.out.println(eKey + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Jack", (Object)theProperties.get((Object)"/user/firstName"));
        Assertions.assertEquals((Object)"Tramiel", (Object)theProperties.get((Object)"/user/lastName"));
        Assertions.assertEquals((Object)"Jack", (Object)theProperties.get((Object)"user/firstName"));
        Assertions.assertEquals((Object)"Tramiel", (Object)theProperties.get((Object)"user/lastName"));
    }

    @Test
    public void testPropertiesDemo() throws IOException, ParseException {
        ArrayList theKeys;
        Properties theProperties = PropertiesSugar.toPrecedence((Properties[])new Properties[]{PropertiesSugar.fromSystemProperties(), PropertiesSugar.fromEnvironmentVariables(), PropertiesSugar.seekFromJavaProperties((String)"application.config")});
        Configuration theConfiguration = (Configuration)theProperties.toType(Configuration.class);
        Assertions.assertEquals((Object)"Nolan", (Object)theConfiguration.getUser().getFirstName());
        Assertions.assertEquals((Object)"Bushnell", (Object)theConfiguration.getUser().getLastName());
        Assertions.assertEquals((Object)"admin", (Object)theConfiguration.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfiguration.getDatabase().getPassword());
        Assertions.assertEquals((Object)"jdbc://my/database/url:5161", (Object)theConfiguration.getDatabase().getUrl());
        Assertions.assertEquals((int)240, (int)theConfiguration.getConsole().getHistory());
        Assertions.assertEquals((int)25, (int)theConfiguration.getConsole().getHeight());
        Assertions.assertEquals((Object)true, (Object)theConfiguration.getConsole().isAnsi());
        Properties theProfile = PropertiesSugar.fromProfile((Properties)theProperties);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            theKeys = new ArrayList(theProfile.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
                System.out.println(eKey + " := " + (String)theProfile.get((Object)eKey));
            }
        }
        theConfiguration = (Configuration)theProfile.toType(Configuration.class);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("--------------------------------------------------------------------------------");
            }
            theKeys = new ArrayList(theProfile.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
                System.out.println(eKey + " := " + (String)theProfile.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Jack", (Object)theConfiguration.getUser().getFirstName());
        Assertions.assertEquals((Object)"Tramiel", (Object)theConfiguration.getUser().getLastName());
        Assertions.assertEquals((Object)"admin", (Object)theConfiguration.getDatabase().getUser());
        Assertions.assertEquals((Object)"secret", (Object)theConfiguration.getDatabase().getPassword());
        Assertions.assertEquals((Object)"jdbc://my/database/url:5161", (Object)theConfiguration.getDatabase().getUrl());
        Assertions.assertEquals((int)240, (int)theConfiguration.getConsole().getHistory());
        Assertions.assertEquals((int)25, (int)theConfiguration.getConsole().getHeight());
        Assertions.assertEquals((Object)true, (Object)theConfiguration.getConsole().isAnsi());
    }

    @Disabled(value="Just for educational purposes")
    @Test
    public void blogExanmple() throws IOException, ParseException {
        Properties.PropertiesBuilder theProperties = PropertiesSugar.fromProperties((Property[])new Property[]{PropertiesSugar.toProperty((String)"/user/firstName", (String)"Nolan"), PropertiesSugar.toProperty((String)"/user/lastName", (String)"Bsuhnell"), PropertiesSugar.toProperty((String)"/commodore/user/firstName", (String)"Jack"), PropertiesSugar.toProperty((String)"/commodore/user/lastName", (String)"Tramiel")});
        for (Object ePath : theProperties.keySet()) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println((String)ePath + "=" + (String)theProperties.get(ePath));
        }
        Properties theCommodreProperties = theProperties.retrieveFrom("/commodore");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        for (Object ePath : theCommodreProperties.keySet()) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println((String)ePath + "=" + (String)theCommodreProperties.get(ePath));
        }
        Properties.PropertiesBuilder theBuilder = PropertiesSugar.toPropertiesBuilder((Properties[])new Properties[]{theCommodreProperties});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        for (Object ePath : theBuilder.keySet()) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println((String)ePath + "=" + (String)theBuilder.get(ePath));
        }
        ResourceProperties.ResourcePropertiesBuilder theResourceProperties = PropertiesSugar.saveToTomlProperties((Properties)theProperties, (String)"/some/path/to/my/properties.toml");
        theResourceProperties = PropertiesSugar.loadFromTomlProperties((String)"/some/path/to/my/properties.toml");
        theResourceProperties = PropertiesSugar.fileToTomlProperties((Properties)theProperties, (String)"properties.toml");
        theResourceProperties = PropertiesSugar.seekFromTomlProperties((String)"properties.toml");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        for (Object ePath : theResourceProperties.keySet()) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println((String)ePath + "=" + (String)theResourceProperties.get(ePath));
        }
        Properties theProfile = PropertiesSugar.fromProfile((Properties)theProperties, (String[])new String[]{"commodore"});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        for (String ePath : theProfile.keySet()) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println(ePath + "=" + (String)theProfile.get((Object)ePath));
        }
        ScheduledResourceProperties.ScheduledResourcePropertiesBuilder theScheduled = PropertiesSugar.schedule((ResourceProperties.ResourcePropertiesBuilder)theResourceProperties, (int)5000, (ReloadMode)ReloadMode.ORPHAN_REMOVAL);
        theScheduled.stopUnchecked();
        Properties.PropertiesBuilder theProps = PropertiesSugar.fromProperties((Property[])new Property[]{PropertiesSugar.toProperty((String)"message", (String)"Hello world!"), PropertiesSugar.toProperty((String)"foo", (String)"bar")});
        PropertiesSugar.fileToTomlProperties((Properties)theProps, (String)"application.toml");
        Properties thePrecedence = PropertiesSugar.toPrecedence((Properties[])new Properties[]{PropertiesSugar.fromSystemProperties(), PropertiesSugar.fromEnvironmentVariables(), PropertiesSugar.seekFromTomlProperties((String)"application.toml")});
        Configuration theConfig = (Configuration)thePrecedence.toType(Configuration.class);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theConfig);
        }
    }

    public static class Configuration {
        private User _user;
        private DatabaseConnection _database;
        private Console _console;

        public User getUser() {
            return this._user;
        }

        public void setUser(User user) {
            this._user = user;
        }

        public DatabaseConnection getDatabase() {
            return this._database;
        }

        public void setDatabase(DatabaseConnection database) {
            this._database = database;
        }

        public Console getConsole() {
            return this._console;
        }

        public void setConsole(Console console) {
            this._console = console;
        }

        public String toString() {
            return "Configuration [user=" + this._user + ", database=" + this._database + ", console=" + this._console + "]";
        }
    }

    public static class User {
        private String _firstName;
        private String _lastName;

        public String getFirstName() {
            return this._firstName;
        }

        public void setFirstName(String firstName) {
            this._firstName = firstName;
        }

        public String getLastName() {
            return this._lastName;
        }

        public void setLastName(String lastName) {
            this._lastName = lastName;
        }

        public String toString() {
            return "User [firstName=" + this._firstName + ", lastName=" + this._lastName + "]";
        }
    }

    public static class DatabaseConnection {
        private String _user;
        private String _password;
        private String _url;

        public String getUser() {
            return this._user;
        }

        public void setUser(String user) {
            this._user = user;
        }

        public String getPassword() {
            return this._password;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getUrl() {
            return this._url;
        }

        public void setUrl(String url) {
            this._url = url;
        }

        public String toString() {
            return "DatabaseConnection [user=" + this._user + ", password=" + this._password + ", url=" + this._url + "]";
        }
    }

    public static class Console {
        private int _history;
        private int _height;
        private boolean _ansi;

        public int getHistory() {
            return this._history;
        }

        public void setHistory(int history) {
            this._history = history;
        }

        public int getHeight() {
            return this._height;
        }

        public void setHeight(int height) {
            this._height = height;
        }

        public boolean isAnsi() {
            return this._ansi;
        }

        public void setAnsi(boolean ansi) {
            this._ansi = ansi;
        }

        public String toString() {
            return "Console [history=" + this._history + ", height=" + this._height + ", ansi=" + this._ansi + "]";
        }
    }
}

