/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.AbstractResourcePropertiesBuilder;
import org.refcodes.properties.ComplexType;
import org.refcodes.properties.JavaPropertiesBuilder;
import org.refcodes.properties.JsonPropertiesBuilder;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.runtime.SystemProperty;

public class ResourcePropertiesTest {
    @Test
    public void testJavaProperties() throws IOException, ParseException {
        ResourceProperties.ResourcePropertiesBuilder theProperties = new JavaPropertiesBuilder().withSeekFrom("application.config");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            ArrayList theKeys = new ArrayList(theProperties.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
                System.out.println(eKey + " := " + (String)theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"/user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"/user/lastName"));
        Assertions.assertEquals((Object)"Nolan", (Object)theProperties.get((Object)"user/firstName"));
        Assertions.assertEquals((Object)"Bushnell", (Object)theProperties.get((Object)"user/lastName"));
    }

    @Test
    public void testComplexType() throws IOException, ParseException {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("JSON");
        }
        JsonPropertiesBuilder theJsonProperties = new JsonPropertiesBuilder(this.getClass(), "/ComplexType.json");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theJsonProperties.sortedKeys()) {
                System.out.println(eKey + " = " + (String)theJsonProperties.get((Object)eKey));
            }
        }
        ComplexType theJsonType = (ComplexType)theJsonProperties.toType(ComplexType.class);
        Assertions.assertEquals((Object)theJsonType.getLocale(), (Object)Locale.GERMANY);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("\nTYPE");
        }
        PropertiesBuilderImpl theTypeProperties = new PropertiesBuilderImpl((Object)theJsonType);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theTypeProperties.sortedKeys()) {
                System.out.println(eKey + " = " + (String)theTypeProperties.get((Object)eKey));
            }
        }
        ComplexType theTypeType = (ComplexType)theTypeProperties.toType(ComplexType.class);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("theJsonType.getLocale() = " + theJsonType.getLocale());
            System.out.println("theTypeType.getLocale() = " + theTypeType.getLocale());
        }
        Assertions.assertEquals((int)theJsonProperties.size(), (int)theTypeProperties.size());
        Assertions.assertEquals((Object)theJsonType.getLocale(), (Object)theTypeType.getLocale());
        Assertions.assertEquals((Object)theJsonType.getTimestamp(), (Object)theTypeType.getTimestamp());
        Assertions.assertEquals((Object)theJsonType.getLocalTimestamp(), (Object)theTypeType.getLocalTimestamp());
    }

    @Test
    public void testToDelimiters1() {
        char[] theDelimiters = AbstractResourcePropertiesBuilder.toDelimiters((char)'/', (char[])new char[0], (char[])new char[]{'/', '.'});
        Assertions.assertArrayEquals((char[])new char[]{'/', '.'}, (char[])theDelimiters);
    }

    @Test
    public void testToDelimiters2() {
        char[] theDelimiters = AbstractResourcePropertiesBuilder.toDelimiters((char)'.', (char[])new char[0], (char[])new char[]{'/', '.'});
        Assertions.assertArrayEquals((char[])new char[]{'.', '/'}, (char[])theDelimiters);
    }

    @Test
    public void testToDelimiters3() {
        char[] theDelimiters = AbstractResourcePropertiesBuilder.toDelimiters((char)'|', (char[])new char[0], (char[])new char[]{'/', '.'});
        Assertions.assertArrayEquals((char[])new char[]{'|', '/', '.'}, (char[])theDelimiters);
    }

    @Test
    public void testToDelimiters4() {
        char[] theDelimiters = AbstractResourcePropertiesBuilder.toDelimiters((char)'|', (char[])new char[]{'/', '.'}, (char[])new char[]{'X', 'Y'});
        Assertions.assertArrayEquals((char[])new char[]{'/', '.'}, (char[])theDelimiters);
    }

    @Test
    public void testToDelimiters5() {
        char[] theDelimiters = AbstractResourcePropertiesBuilder.toDelimiters((char)'|', (char[])new char[]{'/', '.'}, null);
        Assertions.assertArrayEquals((char[])new char[]{'/', '.'}, (char[])theDelimiters);
    }
}

