/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.properties.AbstractResourcePropertiesTest;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.TomlPropertiesBuilder;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.SystemProperty;

public class TomlPropertiesTest
extends AbstractResourcePropertiesTest {
    @Test
    public void testDelimiter1() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("donaBaileyDelimiter1.ini", ConfigLocator.APPLICATION_ALL, new char[]{'/'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter1Other() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("donaBaileyDelimiter1.ini", ConfigLocator.APPLICATION_ALL, new char[]{'|'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter2() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("donaBaileyDelimiter2.ini", ConfigLocator.APPLICATION_ALL, new char[]{'\\'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter2Other() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("donaBaileyDelimiter2.ini", ConfigLocator.APPLICATION_ALL, new char[]{'/'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity\\firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity\\lastName"));
    }

    @Test
    public void testDelimiter3() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("donaBaileyDelimiter3.ini", ConfigLocator.APPLICATION_ALL, new char[]{'\\', '|'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Test
    public void testDelimiter3Other() throws IOException, ParseException {
        TomlProperties theProperties = new TomlProperties("donaBaileyDelimiter3.ini", ConfigLocator.APPLICATION_ALL, new char[]{'/'});
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/\\game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/|identity\\firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/\\identity|lastName"));
    }

    @Override
    protected ResourceProperties.ResourcePropertiesBuilder toResourcePropertiesBuilder() {
        return new TomlPropertiesBuilder();
    }

    @Override
    protected ResourceProperties toResourceProperties(InputStream aInputStream) throws IOException, ParseException {
        return new TomlProperties(aInputStream);
    }
}

