/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.properties.AbstractResourcePropertiesTest;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.XmlProperties;
import org.refcodes.properties.XmlPropertiesBuilder;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.SystemProperty;

public class XmlPropertiesTest
extends AbstractResourcePropertiesTest {
    @Test
    public void tesVerifyEdgeCase() throws MarshalException, UnmarshalException, IOException, ParseException {
        XmlPropertiesBuilder theDataStructure = new XmlPropertiesBuilder();
        theDataStructure.put("aaa/aaa_111", (Object)"aaa_111");
        theDataStructure.put("aaa/aaa_222", (Object)"aaa_222");
        theDataStructure.put("aaa/aaa_333", (Object)"aaa_333");
        theDataStructure.put("bbb/bbb_111", (Object)"bbb_111");
        theDataStructure.put("bbb/bbb_222", (Object)"bbb_222");
        theDataStructure.put("bbb/bbb_333", (Object)"bbb_333");
        theDataStructure.put("ccc/ccc_111", (Object)"ccc_111");
        theDataStructure.put("ccc/ccc_222", (Object)"ccc_222");
        theDataStructure.put("ccc/ccc_333", (Object)"ccc_333");
        String theMarshaled = theDataStructure.toSerialized();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theMarshaled);
        }
        XmlPropertiesBuilder theUnmarshaled = new XmlPropertiesBuilder();
        ByteArrayInputStream theUnmarshaledStream = new ByteArrayInputStream(theMarshaled.getBytes(StandardCharsets.UTF_8));
        theUnmarshaled.loadFrom((InputStream)theUnmarshaledStream);
        Assertions.assertEquals((int)theDataStructure.size(), (int)theUnmarshaled.size());
        for (String eKey : theDataStructure.keySet()) {
            Assertions.assertEquals((Object)theDataStructure.get((Object)eKey), (Object)theUnmarshaled.get((Object)eKey));
        }
    }

    @Test
    public void testDocumentRootPreserve() throws IOException, ParseException {
        XmlProperties theProperties = new XmlProperties("donaBaileyEnvelope.xml", ConfigLocator.APPLICATION_ALL, true);
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/envelope/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/envelope/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/envelope/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/envelope/identity/lastName"));
    }

    @Test
    public void testDocumentRootSkip() throws IOException, ParseException {
        XmlProperties theProperties = new XmlProperties("donaBaileyEnvelope.xml", ConfigLocator.APPLICATION_ALL, false);
        List theKeys = theProperties.sortedKeys();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (String eKey : theKeys) {
                System.out.println(eKey + " = " + theProperties.get((Object)eKey));
            }
        }
        Assertions.assertEquals((int)4, (int)theProperties.size());
        Assertions.assertEquals((Object)"Atari", (Object)theProperties.get((Object)"/company"));
        Assertions.assertEquals((Object)"Centipede", (Object)theProperties.get((Object)"/game"));
        Assertions.assertEquals((Object)"Dona", (Object)theProperties.get((Object)"/identity/firstName"));
        Assertions.assertEquals((Object)"Bailey", (Object)theProperties.get((Object)"/identity/lastName"));
    }

    @Override
    protected ResourceProperties.ResourcePropertiesBuilder toResourcePropertiesBuilder() {
        return new XmlPropertiesBuilder();
    }

    @Override
    protected ResourceProperties toResourceProperties(InputStream aInputStream) throws IOException, ParseException {
        return new XmlProperties(aInputStream);
    }
}

