/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting.ext.observer;

import java.util.concurrent.ExecutorService;
import org.refcodes.component.ext.observer.ClosedEvent;
import org.refcodes.component.ext.observer.ClosedEventImpl;
import org.refcodes.component.ext.observer.OpenedEvent;
import org.refcodes.component.ext.observer.OpenedEventImpl;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.VetoException;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.observer.Event;
import org.refcodes.observer.MetaDataEvent;
import org.refcodes.remoting.RemoteClientImpl;
import org.refcodes.remoting.ext.observer.ConsumerRemoteObserver;
import org.refcodes.remoting.ext.observer.ObservableRemoteClient;
import org.refcodes.remoting.ext.observer.ProxyPublishedEvent;
import org.refcodes.remoting.ext.observer.ProxyPublishedEventImpl;
import org.refcodes.remoting.ext.observer.ProxySignedOffEvent;
import org.refcodes.remoting.ext.observer.ProxySignedOffEventImpl;
import org.refcodes.remoting.ext.observer.PublishProxyEvent;
import org.refcodes.remoting.ext.observer.PublishProxyEventImpl;
import org.refcodes.remoting.ext.observer.SignOffProxyEvent;

public class ObservableRemoteClientImpl
extends RemoteClientImpl
implements ObservableRemoteClient {
    private ConsumerRemoteObservableImpl _observable = new ConsumerRemoteObservableImpl(this.getExecutorService());

    public ObservableRemoteClientImpl() {
        this(null);
    }

    public ObservableRemoteClientImpl(ExecutorService aExecutorService) {
        super(aExecutorService);
    }

    public boolean hasObserverSubscription(ConsumerRemoteObserver aObserver) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._observable.hasObserverSubscription(aObserver);
    }

    public boolean subscribeObserver(ConsumerRemoteObserver aObserver) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._observable.subscribeObserver(aObserver);
    }

    public boolean unsubscribeObserver(ConsumerRemoteObserver aObserver) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._observable.unsubscribeObserver(aObserver);
    }

    public void destroy() {
        if (!this.isDestroyed()) {
            super.destroy();
            this._observable.clear();
            this._observable = null;
        }
    }

    protected void onOpened() {
        if (!this._observable.isEmpty()) {
            try {
                this._observable.fireEvent((MetaDataEvent<?>)new OpenedEventImpl((Object)this));
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    protected void onPublishProxy(Class<?> aType) throws VetoException {
        if (!this._observable.isEmpty()) {
            this._observable.fireEvent(new PublishProxyEventImpl(aType, this));
        }
    }

    protected void onProxyPublished(Object aProxy) {
        try {
            this._observable.fireEvent(new ProxyPublishedEventImpl(aProxy, this));
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    protected void onProxySignedOff(Object aProxy) {
        if (!this._observable.isEmpty()) {
            ProxySignedOffEventImpl theProxySignedOffEvent = new ProxySignedOffEventImpl(aProxy, this);
            try {
                this._observable.fireEvent(theProxySignedOffEvent);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    protected void onClosed() {
        if (!this._observable.isEmpty()) {
            try {
                this._observable.fireEvent((MetaDataEvent<?>)new ClosedEventImpl((Object)this));
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    private static class ConsumerRemoteObservableImpl
    extends AbstractObservable<ConsumerRemoteObserver, MetaDataEvent<?>> {
        public ConsumerRemoteObservableImpl(ExecutorService aExecutorService) {
            super(aExecutorService);
        }

        public int size() {
            return super.size();
        }

        public boolean isEmpty() {
            return super.isEmpty();
        }

        public void clear() {
            super.clear();
        }

        protected boolean fireEvent(MetaDataEvent<?> aEvent) throws VetoException {
            return super.fireEvent(aEvent, ExecutionStrategy.PARALLEL);
        }

        protected boolean fireEvent(MetaDataEvent<?> aEvent, ConsumerRemoteObserver aObserver, ExecutionStrategy aEventExecutionStrategy) throws VetoException {
            if (aEvent instanceof PublishProxyEvent) {
                aObserver.onPublishProxyEvent((PublishProxyEvent)aEvent);
            } else if (aEvent instanceof ProxyPublishedEvent) {
                aObserver.onProxyPublishedEvent((ProxyPublishedEvent)aEvent);
            } else if (aEvent instanceof SignOffProxyEvent) {
                aObserver.onSignOffProxyEvent((SignOffProxyEvent)aEvent);
            } else if (aEvent instanceof ProxySignedOffEvent) {
                aObserver.onProxySignedOffEvent((ProxySignedOffEvent)aEvent);
            } else if (aEvent instanceof OpenedEvent) {
                aObserver.onOpendEvent((OpenedEvent)aEvent);
            } else if (aEvent instanceof ClosedEvent) {
                aObserver.onClosedEvent((ClosedEvent)aEvent);
            }
            aObserver.onEvent((Event)aEvent);
            return true;
        }
    }
}

