/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting.ext.observer;

import java.util.concurrent.ExecutorService;
import org.refcodes.component.ext.observer.ClosedEvent;
import org.refcodes.component.ext.observer.ClosedEventImpl;
import org.refcodes.component.ext.observer.OpenedEvent;
import org.refcodes.component.ext.observer.OpenedEventImpl;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.VetoException;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.observer.Event;
import org.refcodes.observer.MetaDataEvent;
import org.refcodes.remoting.RemoteServerImpl;
import org.refcodes.remoting.ext.observer.ObservableRemoteServer;
import org.refcodes.remoting.ext.observer.ProviderRemoteObserver;
import org.refcodes.remoting.ext.observer.SubjectPublishedEvent;
import org.refcodes.remoting.ext.observer.SubjectPublishedEventImpl;
import org.refcodes.remoting.ext.observer.SubjectSignedOffEvent;
import org.refcodes.remoting.ext.observer.SubjectSignedOffEventImpl;

public class ObservableRemoteServerImpl
extends RemoteServerImpl
implements ObservableRemoteServer {
    private ProviderRemoteObservableImpl _observable = new ProviderRemoteObservableImpl(this.getExecutorService());

    public ObservableRemoteServerImpl() {
        this(null);
    }

    public ObservableRemoteServerImpl(ExecutorService aExecutorService) {
        super(aExecutorService);
    }

    public boolean hasObserverSubscription(ProviderRemoteObserver aObserver) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._observable.hasObserverSubscription(aObserver);
    }

    public boolean subscribeObserver(ProviderRemoteObserver aObserver) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._observable.subscribeObserver(aObserver);
    }

    public boolean unsubscribeObserver(ProviderRemoteObserver aObserver) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._observable.unsubscribeObserver(aObserver);
    }

    public void destroy() {
        if (!this.isDestroyed()) {
            super.destroy();
            this._observable.clear();
            this._observable = null;
        }
    }

    protected void onOpened() {
        if (!this._observable.isEmpty()) {
            try {
                this._observable.fireEvent((MetaDataEvent<?>)new OpenedEventImpl((Object)this));
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    protected void onSubjectPublished(Object aSubject) {
        if (!this._observable.isEmpty()) {
            try {
                this._observable.fireEvent(new SubjectPublishedEventImpl(aSubject, this));
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    protected void onSubjectSignedOff(Object aSubject) {
        if (!this._observable.isEmpty()) {
            SubjectSignedOffEventImpl eSubjectSignedOffEvent = new SubjectSignedOffEventImpl(aSubject, this);
            try {
                this._observable.fireEvent(eSubjectSignedOffEvent);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    protected void onClosed() {
        if (!this._observable.isEmpty()) {
            try {
                this._observable.fireEvent((MetaDataEvent<?>)new ClosedEventImpl((Object)this));
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    private static class ProviderRemoteObservableImpl
    extends AbstractObservable<ProviderRemoteObserver, MetaDataEvent<?>> {
        public int size() {
            return super.size();
        }

        public boolean isEmpty() {
            return super.isEmpty();
        }

        public void clear() {
            super.clear();
        }

        public ProviderRemoteObservableImpl(ExecutorService aExecutorService) {
            super(aExecutorService);
        }

        protected boolean fireEvent(MetaDataEvent<?> aEvent) throws VetoException {
            return super.fireEvent(aEvent, ExecutionStrategy.PARALLEL);
        }

        protected boolean fireEvent(MetaDataEvent<?> aEvent, ProviderRemoteObserver aObserver, ExecutionStrategy aEventExecutionStrategy) throws VetoException {
            if (aEvent instanceof SubjectPublishedEvent) {
                aObserver.onSubjectPublishedEvent((SubjectPublishedEvent)aEvent);
            } else if (aEvent instanceof SubjectSignedOffEvent) {
                aObserver.onSubjectSignedOffEvent((SubjectSignedOffEvent)aEvent);
            } else if (aEvent instanceof OpenedEvent) {
                aObserver.onOpendEvent((OpenedEvent)aEvent);
            } else if (aEvent instanceof ClosedEvent) {
                aObserver.onClosedEvent((ClosedEvent)aEvent);
            }
            aObserver.onEvent((Event)aEvent);
            return true;
        }
    }
}

