/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting.impls;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.DigestException;
import org.refcodes.component.OpenException;
import org.refcodes.component.Resetable;
import org.refcodes.component.impls.AbstractConnectableAutomaton;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.impls.RetryCounterImpl;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.factory.impls.AbstractTypedRecyclingFactory;
import org.refcodes.io.DatagramTransceiver;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.Disposable;
import org.refcodes.remoting.CloseConnectionMessage;
import org.refcodes.remoting.Message;
import org.refcodes.remoting.Remote;
import org.refcodes.remoting.impls.CancelMethodReplyMessageImpl;
import org.refcodes.remoting.impls.CloseConnectionMessageImpl;
import org.refcodes.remoting.impls.PublishSubjectReplyMessageImpl;

public abstract class AbstractRemote
extends AbstractConnectableAutomaton
implements Remote {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    DatagramTransceiver<Serializable> _transceiver;
    JobReceiverDaemon _jobReceiverDaemon = null;
    private JobDigesterDaemonFactoryImpl _jobDigesterDaemonFactory = new JobDigesterDaemonFactoryImpl();
    private ExecutorService _executorService;
    private boolean _isDestroyed = false;

    public AbstractRemote() {
        this(null);
    }

    public AbstractRemote(ExecutorService aExecutorService) {
        this._executorService = aExecutorService == null ? ControlFlowUtility.createDaemonExecutorService() : ControlFlowUtility.toManagedExecutorService((ExecutorService)aExecutorService);
    }

    public boolean isOpenable(DatagramTransceiver<Serializable> aConnection) {
        return super.isOpenable() && aConnection.isOpened();
    }

    public synchronized void open(DatagramTransceiver<Serializable> aTransceiver) throws OpenException {
        this._transceiver = aTransceiver;
        ControlFlowUtility.throwIllegalStateException((this._isDestroyed || this.isOpened() ? 1 : 0) != 0);
        ConnectionStatus theConnectionStatus = this._transceiver.getConnectionStatus();
        if (theConnectionStatus != ConnectionStatus.OPENED) {
            throw new OpenException("Unable to open the remote of type <" + this.getClass().getName() + "> as the underlying transcivier of type <" + this._transceiver.getClass().getName() + "> is in status " + theConnectionStatus + " (not open; please open it beofrehand).");
        }
        this._jobReceiverDaemon = new JobReceiverDaemon();
        LOGGER.debug("Starting job receiver daemon <" + this._jobReceiverDaemon.getClass().getName() + ">.");
        this._executorService.execute(this._jobReceiverDaemon);
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    public synchronized void close() throws CloseException {
        if (this.isClosed()) {
            return;
        }
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDestroyed);
        super.close();
        this._jobReceiverDaemon.dispose();
        this._jobReceiverDaemon = null;
        if (this._transceiver.isOpened()) {
            this._transceiver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        if (this._isDestroyed) return;
        try {
            this.close();
            return;
        }
        catch (CloseException e) {
            LOGGER.warn("Destroying failed as of: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            return;
        }
        finally {
            this._executorService.shutdownNow();
            try {
                this._transceiver.close();
            }
            catch (CloseException e) {
                LOGGER.warn("Destroying failed as of: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            }
            finally {
                this._isDestroyed = true;
            }
        }
    }

    protected abstract void digest(Message var1) throws DigestException;

    protected void toReceiver(Message aJob) throws OpenException {
        block2: {
            try {
                this._transceiver.writeDatagram((Serializable)aJob);
            }
            catch (OpenException aException) {
                if (aJob instanceof CloseConnectionMessage) break block2;
                throw aException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fromSender(Message aJob) {
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDestroyed);
        if (this.isOpened()) {
            if (aJob instanceof CloseConnectionMessage) {
                AbstractRemote abstractRemote = this;
                synchronized (abstractRemote) {
                    if (this.isOpened()) {
                        this.close((CloseConnectionMessage)aJob);
                    }
                }
            } else {
                JobDigesterDaemonImpl theJobDigesterDaemon = (JobDigesterDaemonImpl)this._jobDigesterDaemonFactory.createInstance();
                theJobDigesterDaemon.setInterProcessJob(aJob);
                this._executorService.execute(theJobDigesterDaemon);
            }
        } else {
            if (!(aJob instanceof CloseConnectionMessage)) {
                throw new IllegalStateException("Received a job <" + aJob + "> though this remote \"" + this.getClass().getName() + "\" is not in opened status; connection status is " + this.getConnectionStatus());
            }
            LOGGER.info("Ignoring job of type \"" + aJob.getClass().getName() + "\" being received whilst connection has been closed.");
        }
    }

    protected ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected synchronized void close(CloseConnectionMessage aJob) {
        if (aJob == null) {
            try {
                this.toReceiver(new CloseConnectionMessageImpl());
            }
            catch (OpenException aMessage) {
                LOGGER.warn("Sending a close connection job to the communication couinterpart caused an exception.", (Throwable)aMessage);
            }
        }
    }

    protected boolean isDestroyed() {
        return this._isDestroyed;
    }

    protected void onOpened() {
    }

    protected void onClosed() {
    }

    protected static class PublishSubjectReplyJobFactoryImpl
    extends AbstractTypedRecyclingFactory<PublishSubjectReplyMessageImpl> {
        protected PublishSubjectReplyJobFactoryImpl() {
        }

        protected PublishSubjectReplyMessageImpl newInstance() {
            return new PublishSubjectReplyMessageImpl();
        }

        protected PublishSubjectReplyMessageImpl newInstance(Properties aProperties) {
            return new PublishSubjectReplyMessageImpl();
        }
    }

    protected static class CancelMethodReplyJobFactoryImpl
    extends AbstractTypedRecyclingFactory<CancelMethodReplyMessageImpl> {
        protected CancelMethodReplyJobFactoryImpl() {
        }

        protected CancelMethodReplyMessageImpl newInstance() {
            return new CancelMethodReplyMessageImpl();
        }

        protected CancelMethodReplyMessageImpl newInstance(Properties aProperties) {
            return new CancelMethodReplyMessageImpl();
        }
    }

    protected class JobDigesterDaemonFactoryImpl
    extends AbstractTypedRecyclingFactory<JobDigesterDaemonImpl> {
        protected JobDigesterDaemonFactoryImpl() {
        }

        protected JobDigesterDaemonImpl newInstance() {
            return new JobDigesterDaemonImpl(this);
        }

        protected JobDigesterDaemonImpl newInstance(Properties aProperties) {
            return new JobDigesterDaemonImpl(this);
        }
    }

    private class JobDigesterDaemonImpl
    implements Runnable,
    Resetable {
        private JobDigesterDaemonFactoryImpl _daemonFactory;
        private Message _job = null;

        public JobDigesterDaemonImpl(JobDigesterDaemonFactoryImpl aDaemonFactory) {
            this._daemonFactory = aDaemonFactory;
        }

        public void reset() {
            this.setInterProcessJob(null);
        }

        @Override
        public void run() {
            try {
                AbstractRemote.this.digest(this._job);
            }
            catch (DigestException aException) {
                LOGGER.warn("Unable to digest the job \"" + this._job.getClass().getName() + "\" as of a digest exception: \"" + ExceptionUtility.toMessage((Throwable)aException) + "\"", (Throwable)aException);
            }
            finally {
                this._daemonFactory.recycleInstance(this);
            }
        }

        public void setInterProcessJob(Message aJob) {
            this._job = aJob;
        }
    }

    private class JobReceiverDaemon
    implements Runnable,
    Disposable {
        private boolean _isDisposed = false;

        private JobReceiverDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this._isDisposed && this.isOpened()) {
                    Message eJob = (Message)AbstractRemote.this._transceiver.readDatagram();
                    if (AbstractRemote.this.isOpened()) {
                        AbstractRemote.this.fromSender(eJob);
                        continue;
                    }
                    LOGGER.info("Ignoring job of type \"" + eJob.getClass().getName() + "\" being received whilst connection has been closed.");
                }
            }
            catch (InterruptedException | OpenException aException) {
                boolean isTransceiverClosed = AbstractRemote.this._transceiver.isClosed();
                AbstractRemote abstractRemote = AbstractRemote.this;
                synchronized (abstractRemote) {
                    if (AbstractRemote.this.isOpened()) {
                        try {
                            AbstractRemote.this.close();
                        }
                        catch (CloseException e) {
                            LOGGER.warn("Unable to close the malfunctioning connection: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                        }
                    }
                }
                if (!isTransceiverClosed) {
                    LOGGER.warn("Caught an exception in daemon while reading jobs from the transceiver (receiver); the connection status is " + AbstractRemote.this.getConnectionStatus() + " (will get closed if not already); the transceiver's connection status is " + AbstractRemote.this.getConnectionStatus() + ": " + ExceptionUtility.toMessage((Throwable)aException), aException);
                    throw new HiddenException(aException);
                }
            }
        }

        private boolean isOpened() {
            if (!AbstractRemote.this.isOpened()) {
                return false;
            }
            if (AbstractRemote.this._transceiver.isOpened() && AbstractRemote.this.isOpened()) {
                return true;
            }
            if (AbstractRemote.this.isOpened() && !AbstractRemote.this._transceiver.isOpened()) {
                RetryCounterImpl theRetryCounter = new RetryCounterImpl(5, 3000L, 100L);
                while (AbstractRemote.this.isOpened() && theRetryCounter.hasNextRetry() && !AbstractRemote.this._transceiver.isOpened()) {
                    theRetryCounter.nextRetry();
                }
            }
            return AbstractRemote.this._transceiver.isOpened() && AbstractRemote.this.isOpened();
        }

        public void dispose() {
            this._isDisposed = true;
        }
    }
}

