/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting.impls;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.DigestException;
import org.refcodes.component.OpenException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.impls.RetryTimeoutImpl;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.exception.VetoException;
import org.refcodes.factory.impls.AbstractTypedRecyclingFactory;
import org.refcodes.generator.Generator;
import org.refcodes.generator.impls.UniqueIdGeneratorImpl;
import org.refcodes.io.SerializeUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.BusyAccessor;
import org.refcodes.remoting.CloseConnectionMessage;
import org.refcodes.remoting.DuplicateInstanceIdRuntimeException;
import org.refcodes.remoting.Instance;
import org.refcodes.remoting.InvalidMethodReplyRuntimeException;
import org.refcodes.remoting.InvalidMethodRequestRuntimeException;
import org.refcodes.remoting.Message;
import org.refcodes.remoting.MethodRequest;
import org.refcodes.remoting.MethodRequestMessage;
import org.refcodes.remoting.PublishSubjectReplyMessage;
import org.refcodes.remoting.RemoteServer;
import org.refcodes.remoting.Reply;
import org.refcodes.remoting.SignOffProxyMessage;
import org.refcodes.remoting.Subject;
import org.refcodes.remoting.UnknownInstanceIdRuntimeException;
import org.refcodes.remoting.impls.AbstractRemote;
import org.refcodes.remoting.impls.CancelMethodReplyMessageImpl;
import org.refcodes.remoting.impls.ClassDescriptorImpl;
import org.refcodes.remoting.impls.InstanceDescriptorImpl;
import org.refcodes.remoting.impls.MethodReplyMessageImpl;
import org.refcodes.remoting.impls.PublishSubjectMessageImpl;
import org.refcodes.remoting.impls.PublishSubjectReplyMessageImpl;
import org.refcodes.remoting.impls.ReplyDescriptorImpl;
import org.refcodes.remoting.impls.SignoffSubjectMessageImpl;
import org.refcodes.remoting.impls.SubjectInstanceDescriptorImpl;

public class RemoteServerImpl
extends AbstractRemote
implements RemoteServer {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private InstanceHandler _instanceHandler = new InstanceHandler();
    private AbstractRemote.CancelMethodReplyJobFactoryImpl _cancelMethodReplyJobFactory = new AbstractRemote.CancelMethodReplyJobFactoryImpl();
    private MethodReplyJobFactoryImpl _methodReplyJobFactory = new MethodReplyJobFactoryImpl();
    private SignOffJobFactoryImpl _signOffJobFactory = new SignOffJobFactoryImpl();
    private PublishProxyJobFactoryImpl _publishProxyJobFactory = new PublishProxyJobFactoryImpl();
    private AbstractRemote.PublishSubjectReplyJobFactoryImpl _publishSubjectReplyJobFactory = new AbstractRemote.PublishSubjectReplyJobFactoryImpl();
    private Generator<String> _instanceIdGenerator = new UniqueIdGeneratorImpl(16);

    public RemoteServerImpl() {
        super(null);
    }

    public RemoteServerImpl(ExecutorService aExecutorService) {
        super(aExecutorService);
    }

    public void clear() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        this.signOffAllSubjects();
    }

    @Override
    public synchronized void close() {
        this.close(null);
    }

    public boolean isBusy() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.isBusy();
    }

    @Override
    public boolean hasSubject(Object obj) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.hasSubject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> subjects() {
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            ArrayList<Object> thjeList = new ArrayList<Object>(this._instanceHandler.getSubjects());
            return thjeList.iterator();
        }
    }

    public boolean isEmpty() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publishSubject(Object aSubject) throws OpenException {
        ControlFlowUtility.throwIllegalStateException((this.isDestroyed() && !this.isOpened() ? 1 : 0) != 0);
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            Iterator<Subject> e = this._instanceHandler.subjectDescriptors();
            while (e.hasNext()) {
                Subject eObjDescriptor = e.next();
                if (eObjDescriptor.getSubject() != aSubject) continue;
                return false;
            }
            if (!this._instanceHandler.hasSubject(aSubject)) {
                String theInstanceId = null;
                Generator<String> generator = this._instanceIdGenerator;
                synchronized (generator) {
                    if (!this._instanceIdGenerator.hasNext()) {
                        throw new IllegalStateException("The instance ID generator in use is unable to produce more instance IDs.");
                    }
                    theInstanceId = (String)this._instanceIdGenerator.next();
                }
                if (this._instanceHandler.hasInstanceId(theInstanceId)) {
                    throw new DuplicateInstanceIdRuntimeException("The instance ID generator in use produces duplicate instance IDs.");
                }
                SubjectInstanceDescriptorImpl theSubjectInstanceDescriptor = new SubjectInstanceDescriptorImpl(aSubject, theInstanceId);
                ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(aSubject.getClass(), theInstanceId);
                if (this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
                    throw new DuplicateInstanceIdRuntimeException("The instance ID <" + theInstanceId + "> is already in use by the internal instance handler.");
                }
                PublishSubjectMessageImpl thePublishSubjectJob = (PublishSubjectMessageImpl)this._publishProxyJobFactory.createInstance();
                thePublishSubjectJob.setClassDescriptor(classDescriptor);
                PublishSubjectReplyMessageImpl theMethodReplyRemotingJob = (PublishSubjectReplyMessageImpl)this._publishSubjectReplyJobFactory.createInstance();
                theMethodReplyRemotingJob.setInstanceId(theInstanceId);
                theMethodReplyRemotingJob.setHasReply(false);
                this._instanceHandler.addReplyDescriptor(theMethodReplyRemotingJob, theInstanceId);
                try {
                    this.toReceiver(thePublishSubjectJob);
                }
                catch (OpenException aException) {
                    LOGGER.warn(ExceptionUtility.toMessage((Throwable)aException), (Throwable)aException);
                    this._instanceHandler.removeReplyDescriptor(theInstanceId);
                    if (aException.getCause() instanceof IOException) {
                        this.closeOnException();
                    }
                    this._publishSubjectReplyJobFactory.recycleInstance(theMethodReplyRemotingJob);
                    throw aException;
                }
                RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(30000L, 250);
                while (!theMethodReplyRemotingJob.hasReply() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
                    theRetryTimeout.nextRetry((Object)theMethodReplyRemotingJob);
                }
                this._instanceHandler.removeReplyDescriptor(theInstanceId);
                if (!theMethodReplyRemotingJob.hasReply()) {
                    this._publishSubjectReplyJobFactory.recycleInstance(theMethodReplyRemotingJob);
                    throw new IllegalStateException("While processing the request a timeout of 30000 ms has been overshot; propably lost the connection (you propably should close the connection).");
                }
                if (theMethodReplyRemotingJob.isException()) {
                    this._publishSubjectReplyJobFactory.recycleInstance(theMethodReplyRemotingJob);
                    throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a class descripter. Sorry - operation aborted!");
                }
                if (theMethodReplyRemotingJob.isReturnValue() && theMethodReplyRemotingJob.getReturnValue() instanceof Boolean) {
                    boolean theReturnValue = (Boolean)theMethodReplyRemotingJob.getReturnValue();
                    if (theReturnValue) {
                        this._instanceHandler.addObjectDescriptor(theSubjectInstanceDescriptor, theInstanceId);
                        this.onSubjectPublished(theSubjectInstanceDescriptor.getSubject());
                    }
                    this._publishSubjectReplyJobFactory.recycleInstance(theMethodReplyRemotingJob);
                    return theReturnValue;
                }
                this._publishSubjectReplyJobFactory.recycleInstance(theMethodReplyRemotingJob);
                throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a class descripter. Sorry - operation aborted!");
            }
            return false;
        }
    }

    @Override
    public boolean signOffSubject(Object aSubject) throws OpenException, VetoException {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        String theSubjectId = this.toSubjectId(aSubject);
        if (theSubjectId == null) {
            return false;
        }
        return this.signoffInstanceDescriptor(new InstanceDescriptorImpl(theSubjectId), -1);
    }

    @Override
    public boolean signOffSubject(Object aSubject, int aTimeoutInMs) throws OpenException {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        String theSubjectId = this.toSubjectId(aSubject);
        if (theSubjectId == null) {
            return false;
        }
        try {
            return this.signoffInstanceDescriptor(new InstanceDescriptorImpl(theSubjectId), aTimeoutInMs);
        }
        catch (VetoException aException) {
            throw new HiddenException((Throwable)aException);
        }
    }

    public int size() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.size();
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyed()) {
            super.destroy();
            this._instanceHandler.clear();
            this._instanceHandler = null;
            this._cancelMethodReplyJobFactory.clear();
            this._cancelMethodReplyJobFactory = null;
            this._methodReplyJobFactory.clear();
            this._methodReplyJobFactory = null;
            this._publishProxyJobFactory.clear();
            this._publishProxyJobFactory = null;
            this._publishSubjectReplyJobFactory.clear();
            this._publishSubjectReplyJobFactory = null;
            this._signOffJobFactory.clear();
            this._signOffJobFactory = null;
            this._instanceIdGenerator = null;
        }
    }

    protected void doSendJob(Message aJob) throws OpenException {
        this.toReceiver(aJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(Message aJob) throws DigestException {
        block15: {
            try {
                if (aJob == null) {
                    return;
                }
                if (aJob instanceof CloseConnectionMessage) {
                    this.close((CloseConnectionMessage)aJob);
                    break block15;
                }
                if (aJob instanceof PublishSubjectReplyMessage) {
                    PublishSubjectReplyMessage theReplyRemotingJob = (PublishSubjectReplyMessage)aJob;
                    if (theReplyRemotingJob.getInstanceId() == null) {
                        return;
                    }
                    String theInstanceId = theReplyRemotingJob.getInstanceId();
                    if (!this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
                        throw new UnknownInstanceIdRuntimeException("Expected an instance ID <" + theInstanceId + "> which was not found in order to reply to a request...");
                    }
                    Reply tmpReply = this._instanceHandler.getMethodReplyDescriptor(theInstanceId);
                    if (!(tmpReply instanceof PublishSubjectReplyMessage)) {
                        throw new InvalidMethodReplyRuntimeException("Excpected a <" + PublishSubjectReplyMessage.class.toString() + "> to put the reply in.");
                    }
                    PublishSubjectReplyMessage thePublishSubjectReplyJob = (PublishSubjectReplyMessage)tmpReply;
                    thePublishSubjectReplyJob.setReply(theReplyRemotingJob);
                    PublishSubjectReplyMessage publishSubjectReplyMessage = thePublishSubjectReplyJob;
                    synchronized (publishSubjectReplyMessage) {
                        thePublishSubjectReplyJob.notifyAll();
                        break block15;
                    }
                }
                if (aJob instanceof MethodRequestMessage) {
                    MethodRequest theMethodRequestDescriptor = (MethodRequest)((Object)aJob);
                    Reply theMethodReplyDescriptor = this.pushMethodRequest(theMethodRequestDescriptor);
                    if (theMethodReplyDescriptor == null) {
                        return;
                    }
                    MethodReplyMessageImpl theMethodReplyJob = (MethodReplyMessageImpl)this._methodReplyJobFactory.createInstance();
                    theMethodReplyJob.setMethodReplyDescriptor(theMethodReplyDescriptor);
                    this.toReceiver(theMethodReplyJob);
                } else if (aJob instanceof SignOffProxyMessage) {
                    Message instanceDescriptor = aJob;
                    boolean theReturnValue = this.serviceSignoffInstanceDescriptor(instanceDescriptor);
                    CancelMethodReplyMessageImpl theCancelReplyRemotingJob = (CancelMethodReplyMessageImpl)this._cancelMethodReplyJobFactory.createInstance();
                    theCancelReplyRemotingJob.setInstanceId(instanceDescriptor.getInstanceId());
                    theCancelReplyRemotingJob.setException(null);
                    theCancelReplyRemotingJob.setReturnValue(new Boolean(theReturnValue));
                    theCancelReplyRemotingJob.setHasReply(true);
                    this.toReceiver(theCancelReplyRemotingJob);
                }
            }
            catch (OpenException aException) {
                throw new DigestException((Throwable)aException);
            }
        }
    }

    @Override
    protected synchronized void close(CloseConnectionMessage aJob) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        if (!this.isClosed()) {
            super.close(aJob);
            RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(20000L, 100);
            while (this.isBusy() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
                theRetryTimeout.nextRetry();
            }
            if (this.isBusy()) {
                LOGGER.warn("Still being BUSY even after reaching the timeout of <20000> ms, closing connection nonetheless.");
            }
            this.signOffAllSubjects();
            try {
                super.close();
            }
            catch (CloseException e) {
                LOGGER.warn("Unable to close malfunctioning connection.", (Throwable)e);
            }
            this.onClosed();
        }
    }

    protected void onSubjectPublished(Object aSubject) {
    }

    protected void onSubjectSignedOff(Object aSubject) {
    }

    private boolean signOffSubjectDescriptor(Subject aSubjectDescriptor) throws OpenException {
        boolean theResult;
        if (this.isClosed()) {
            return false;
        }
        String eId = null;
        Iterator<String> e = this._instanceHandler.instanceIds();
        while (e.hasNext() && this._instanceHandler.getObjectDescriptor(eId = e.next()) != aSubjectDescriptor) {
        }
        if (eId == null) {
            return false;
        }
        try {
            theResult = this.signoffInstanceDescriptor(new InstanceDescriptorImpl(eId), 0);
        }
        catch (VetoException ve) {
            theResult = true;
        }
        return theResult;
    }

    private String toSubjectId(Object aSubject) {
        String eId = null;
        boolean returnValue = false;
        Iterator<Object> e = this.subjects();
        while (e.hasNext()) {
            Object eObj = e.next();
            if (eObj != aSubject) continue;
            returnValue = true;
        }
        if (!returnValue) {
            return null;
        }
        Iterator<Object> ee = this.subjects();
        while (ee.hasNext()) {
            Object eObj = ee.next();
            if (!(eObj instanceof SubjectInstanceDescriptorImpl) || ((SubjectInstanceDescriptorImpl)eObj).getSubject() != aSubject) continue;
            eId = ((SubjectInstanceDescriptorImpl)eObj).getInstanceId();
        }
        return eId;
    }

    private void clearOnException() {
        Iterator<Subject> e = this._instanceHandler.subjectDescriptors();
        while (e.hasNext()) {
            Subject eObjectDescriptor = e.next();
            this.onSubjectSignedOff(eObjectDescriptor.getSubject());
        }
        this._instanceHandler.clear();
    }

    private void signOffAllSubjects() {
        Iterator<Subject> e = this._instanceHandler.subjectDescriptors();
        while (e.hasNext()) {
            try {
                Subject eObjDescriptor = e.next();
                this.signOffSubjectDescriptor(eObjDescriptor);
            }
            catch (OpenException oe) {
                LOGGER.error("Catched a <ConnectionUnpredictableException> with message = " + oe.getMessage());
                if (!(oe.getCause() instanceof IOException)) continue;
                this.clearOnException();
            }
        }
        this._instanceHandler.clear();
    }

    private void closeOnException() {
        this.clearOnException();
        Iterator<Subject> e = this._instanceHandler.subjectDescriptors();
        while (e.hasNext()) {
            Subject eObjectDescriptor = e.next();
            this.onSubjectSignedOff(eObjectDescriptor.getSubject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reply pushMethodRequest(MethodRequest aMethodRequestDescriptor) throws OpenException {
        Subject objDescriptor;
        if (aMethodRequestDescriptor == null) {
            return null;
        }
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            objDescriptor = this._instanceHandler.getObjectDescriptor(aMethodRequestDescriptor.getInstanceId());
        }
        if (objDescriptor == null) {
            return null;
        }
        try {
            MethodInvokationDaemon theDaemon = new MethodInvokationDaemon(objDescriptor.getSubject(), aMethodRequestDescriptor.getMethodName(), aMethodRequestDescriptor.getArgumentArray(), aMethodRequestDescriptor.getArgumentTypeArray());
            this.getExecutorService().execute(theDaemon);
            RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(24000L, 250);
            while (!theDaemon.hasResult() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
                theRetryTimeout.nextRetry((Object)theDaemon);
            }
            if (!theDaemon.hasResult()) {
                LOGGER.warn("Some timeout has occurred - timeout is ignored...");
            }
            ReplyDescriptorImpl theMethodReplyDescriptor = new ReplyDescriptorImpl(theDaemon.getReturnValue(), theDaemon.getException(), aMethodRequestDescriptor);
            return theMethodReplyDescriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidMethodRequestRuntimeException(iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidMethodRequestRuntimeException(nsme);
        }
    }

    private boolean serviceSignoffInstanceDescriptor(Instance instanceDescriptor) {
        if (instanceDescriptor == null) {
            throw new NullPointerException("Expected an object of type <GenericInstanceDescriptor> instead of a null value in argument <instanceDescriptor>.");
        }
        if (instanceDescriptor.getInstanceId() == null) {
            throw new NullPointerException("Expected an object of type <String> instead of a null value when retrieving the instance id of argument <instanceDescriptor>.");
        }
        String instanceId = instanceDescriptor.getInstanceId();
        if (this._instanceHandler.hasSignedOffInstanceId(instanceId)) {
            return true;
        }
        if (!this._instanceHandler.hasSubject(instanceId)) {
            RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(15000L, 100);
            while (theRetryTimeout.hasNextRetry() && !this._instanceHandler.hasSubject(instanceId)) {
                theRetryTimeout.nextRetry();
            }
            if (!this._instanceHandler.hasSubject(instanceId)) {
                throw new UnknownInstanceIdRuntimeException("Expected a known instance ID in argument <instanceDescriptor> (propably all instances have been signed off), the unkwnown instance ID is <" + instanceId + ">.");
            }
        }
        Subject theSubjectDescriptor = this._instanceHandler.removeSubjectDescriptor(instanceId);
        this.onSubjectSignedOff(theSubjectDescriptor.getSubject());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean signoffInstanceDescriptor(Instance aInstanceDescriptor, int aTimeoutInMs) throws OpenException, VetoException {
        if (aInstanceDescriptor == null) {
            return false;
        }
        if (aInstanceDescriptor.getInstanceId() == null) {
            return false;
        }
        String theInstanceId = aInstanceDescriptor.getInstanceId();
        if (!this._instanceHandler.hasInstanceId(theInstanceId)) {
            return false;
        }
        if (!this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
            return false;
        }
        if (this._instanceHandler.hasSignedOffInstanceId(theInstanceId)) {
            throw new DuplicateInstanceIdRuntimeException("The instance <" + theInstanceId + "> of the provided instance descriptorin is already in use and being used up.");
        }
        SignoffSubjectMessageImpl theSignoffSubjectJob = (SignoffSubjectMessageImpl)this._signOffJobFactory.createInstance();
        theSignoffSubjectJob.setInstanceId(aInstanceDescriptor.getInstanceId());
        theSignoffSubjectJob.setTimeoutInMs(aTimeoutInMs);
        PublishSubjectReplyMessageImpl thePublishSubjectReplyJob = (PublishSubjectReplyMessageImpl)this._publishSubjectReplyJobFactory.createInstance();
        thePublishSubjectReplyJob.setInstanceId(theInstanceId);
        thePublishSubjectReplyJob.setHasReply(false);
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            this._instanceHandler.addReplyDescriptor(thePublishSubjectReplyJob, theInstanceId);
        }
        this.toReceiver(theSignoffSubjectJob);
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(30000L, 250);
        while (!thePublishSubjectReplyJob.hasReply() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
            theRetryTimeout.nextRetry((Object)thePublishSubjectReplyJob);
        }
        InstanceHandler instanceHandler2 = this._instanceHandler;
        synchronized (instanceHandler2) {
            this._instanceHandler.removeReplyDescriptor(theInstanceId);
        }
        if (!thePublishSubjectReplyJob.hasReply()) {
            this._publishSubjectReplyJobFactory.recycleInstance(thePublishSubjectReplyJob);
            throw new IllegalStateException("While processing the request a timeout of 30000 ms has been overshot; propably lost the connection (you propably should close the connection).");
        }
        if (thePublishSubjectReplyJob.isException()) {
            Throwable theException = thePublishSubjectReplyJob.getException();
            if (theException instanceof VetoException) {
                if (aTimeoutInMs != 0) {
                    if (aTimeoutInMs > 0) {
                        RemoteServerImpl remoteServerImpl = this;
                        synchronized (remoteServerImpl) {
                            try {
                                Thread.sleep(aTimeoutInMs);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (aTimeoutInMs == -1) {
                        throw (VetoException)theException;
                    }
                }
            } else {
                throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a subject.");
            }
        }
        if (thePublishSubjectReplyJob.isReturnValue() && thePublishSubjectReplyJob.getReturnValue() instanceof Boolean) {
            Subject theSubjectDescriptor = this._instanceHandler.removeSubjectDescriptor(theInstanceId);
            this.onSubjectSignedOff(theSubjectDescriptor.getSubject());
            return (Boolean)thePublishSubjectReplyJob.getReturnValue();
        }
        this._publishSubjectReplyJobFactory.recycleInstance(thePublishSubjectReplyJob);
        throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a subject.");
    }

    protected static class SignOffJobFactoryImpl
    extends AbstractTypedRecyclingFactory<SignoffSubjectMessageImpl> {
        protected SignOffJobFactoryImpl() {
        }

        protected SignoffSubjectMessageImpl newInstance() {
            return new SignoffSubjectMessageImpl();
        }

        protected SignoffSubjectMessageImpl newInstance(Properties aProperties) {
            return new SignoffSubjectMessageImpl();
        }
    }

    protected static class PublishProxyJobFactoryImpl
    extends AbstractTypedRecyclingFactory<PublishSubjectMessageImpl> {
        protected PublishProxyJobFactoryImpl() {
        }

        protected PublishSubjectMessageImpl newInstance() {
            return new PublishSubjectMessageImpl();
        }

        protected PublishSubjectMessageImpl newInstance(Properties aProperties) {
            return new PublishSubjectMessageImpl();
        }
    }

    protected static class MethodReplyJobFactoryImpl
    extends AbstractTypedRecyclingFactory<MethodReplyMessageImpl> {
        protected MethodReplyJobFactoryImpl() {
        }

        protected MethodReplyMessageImpl newInstance() {
            return new MethodReplyMessageImpl();
        }

        protected MethodReplyMessageImpl newInstance(Properties aProperties) {
            return new MethodReplyMessageImpl();
        }
    }

    private class MethodInvokationDaemon
    implements Runnable {
        private Object[] _argumentArray;
        private boolean _hasResult = false;
        private Method _method;
        private Object _providedObject;
        private Throwable _returnThrowable = null;
        private Object _returnValue = null;

        MethodInvokationDaemon(Object aSubject, String aMethodName, Object[] anArgumentArray, Class<?>[] aParameterArray) throws IllegalArgumentException, NoSuchMethodException {
            this._method = aSubject.getClass().getMethod(aMethodName, aParameterArray);
            this._providedObject = aSubject;
            this._argumentArray = anArgumentArray;
            if (this._argumentArray != null) {
                for (int i = 0; i < this._argumentArray.length; ++i) {
                    this._argumentArray[i] = SerializeUtility.toSerializable((Object)this._argumentArray[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object returnValue = this._method.invoke(this._providedObject, this._argumentArray);
                this._returnValue = SerializeUtility.toSerializable((Object)returnValue);
            }
            catch (InvocationTargetException aInvocationTargetException) {
                LOGGER.warn(ExceptionUtility.toMessage((Throwable)aInvocationTargetException), (Throwable)aInvocationTargetException);
                this._returnThrowable = aInvocationTargetException.getTargetException();
            }
            catch (IllegalAccessException aIllegalAccessException) {
                LOGGER.warn(ExceptionUtility.toMessage((Throwable)aIllegalAccessException), (Throwable)aIllegalAccessException);
                throw new InvalidMethodRequestRuntimeException(aIllegalAccessException);
            }
            catch (Throwable aThrowable) {
                LOGGER.warn(ExceptionUtility.toMessage((Throwable)aThrowable), aThrowable);
                this._returnThrowable = aThrowable;
            }
            finally {
                this._hasResult = true;
                MethodInvokationDaemon aInvocationTargetException = this;
                synchronized (aInvocationTargetException) {
                    this.notifyAll();
                }
            }
        }

        Object getReturnValue() {
            return this._returnValue;
        }

        Throwable getException() {
            return this._returnThrowable;
        }

        boolean hasResult() {
            return this._hasResult;
        }
    }

    private static class InstanceHandler
    implements BusyAccessor {
        private Map<String, Subject> _instanceIdsToSubjectDescriptors = new HashMap<String, Subject>();
        private Map<String, Reply> _instanceIdToMethodReplyDescriptor = new HashMap<String, Reply>();
        private List<Object> _subjects = new ArrayList<Object>();
        private Set<String> _signedOffInstanceIds = Collections.newSetFromMap(new WeakHashMap());

        private InstanceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addObjectDescriptor(Subject theObjectDescriptor, String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (!this._instanceIdsToSubjectDescriptors.containsKey(aInstanceId)) {
                    if (this.hasInstanceId(aInstanceId)) {
                        return false;
                    }
                    if (this.hasSubject(theObjectDescriptor.getSubject())) {
                        return false;
                    }
                    this._instanceIdsToSubjectDescriptors.put(aInstanceId, theObjectDescriptor);
                    this._subjects.add(theObjectDescriptor.getSubject());
                    return true;
                }
            }
            return false;
        }

        boolean addReplyDescriptor(Reply aMethodReplyDescriptor, String aInstanceId) {
            if (this.hasMethodReplyDescriptor(aInstanceId)) {
                return false;
            }
            if (this.hasSignedOffInstanceId(aInstanceId)) {
                return false;
            }
            this._instanceIdToMethodReplyDescriptor.put(aInstanceId, aMethodReplyDescriptor);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSignedOffInstanceId(String instanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                return this._signedOffInstanceIds.add(instanceId);
            }
        }

        void clear() {
            this.clearSignedOffInstanceIds();
            this.clearObjectDescriptos();
            this.clearReplyDescriptors();
        }

        Subject getObjectDescriptor(String aInstanceId) {
            return this._instanceIdsToSubjectDescriptors.get(aInstanceId);
        }

        List<Object> getSubjects() {
            return this._subjects;
        }

        Reply getMethodReplyDescriptor(String aInstanceId) {
            if (!this.hasMethodReplyDescriptor(aInstanceId)) {
                return null;
            }
            if (this.hasSignedOffInstanceId(aInstanceId)) {
                return null;
            }
            return this._instanceIdToMethodReplyDescriptor.get(aInstanceId);
        }

        boolean hasInstanceId(String instanceId) {
            return this._instanceIdsToSubjectDescriptors.containsKey(instanceId) || this._signedOffInstanceIds.contains(instanceId);
        }

        boolean hasSubject(Object obj) {
            return this._subjects.contains(obj);
        }

        boolean hasSubject(String instanceId) {
            return this._instanceIdsToSubjectDescriptors.containsKey(instanceId);
        }

        boolean hasMethodReplyDescriptor(String instanceId) {
            return this._instanceIdToMethodReplyDescriptor.containsKey(instanceId);
        }

        boolean hasSignedOffInstanceId(String instanceId) {
            return this._signedOffInstanceIds.contains(instanceId);
        }

        Iterator<String> instanceIds() {
            return this._instanceIdsToSubjectDescriptors.keySet().iterator();
        }

        boolean isEmpty() {
            return this._subjects.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator<Subject> subjectDescriptors() {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                ArrayList<Subject> returnList = new ArrayList<Subject>(this._instanceIdsToSubjectDescriptors.values());
                return returnList.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Subject removeSubjectDescriptor(String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (this._instanceIdsToSubjectDescriptors.containsKey(aInstanceId)) {
                    Subject theObjectDescriptor = this._instanceIdsToSubjectDescriptors.remove(aInstanceId);
                    if (!this._subjects.contains(theObjectDescriptor.getSubject())) {
                        return null;
                    }
                    if (this.hasSignedOffInstanceId(aInstanceId)) {
                        return null;
                    }
                    this._subjects.remove(theObjectDescriptor.getSubject());
                    this.addSignedOffInstanceId(aInstanceId);
                    return theObjectDescriptor;
                }
            }
            return null;
        }

        Reply removeReplyDescriptor(String aInstanceId) {
            if (!this.hasMethodReplyDescriptor(aInstanceId)) {
                return null;
            }
            if (this.hasSignedOffInstanceId(aInstanceId)) {
                return null;
            }
            return this._instanceIdToMethodReplyDescriptor.remove(aInstanceId);
        }

        int size() {
            return this._subjects.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearObjectDescriptos() {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                this._instanceIdsToSubjectDescriptors.clear();
                this._subjects.clear();
            }
        }

        private void clearReplyDescriptors() {
            this._instanceIdToMethodReplyDescriptor.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearSignedOffInstanceIds() {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                this._signedOffInstanceIds.clear();
            }
        }

        public synchronized boolean isBusy() {
            return !this._instanceIdToMethodReplyDescriptor.isEmpty();
        }
    }
}

