// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import java.io.Serializable;

import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.structure.Clearable;

/**
 * Implementation of the {@link InstanceDescriptor} interface.
 */
class ClassDescriptorImpl implements InstanceDescriptor, Serializable {

	private static final long serialVersionUID = 1L;

	private Class<?> _type;

	private String _instanceId;

	/**
	 * Creates a new ClassDescriptor object.
	 */
	public ClassDescriptorImpl() {}

	/**
	 * Constructs a {@link InstanceDescriptor} instance.
	 * 
	 * @param aClass The class for the subject in question.
	 * 
	 * @param aInstanceId The instance ID of the subject in question.
	 */
	public ClassDescriptorImpl( Class<?> aClass, String aInstanceId ) {
		_instanceId = aInstanceId;
		_type = aClass;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getInstanceId() {
		return _instanceId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Class<?> getType() {
		return _type;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return RuntimeUtility.toString( "Instance ID = <" + _instanceId + ">; class = " + _type.toString(), super.toString() );
	}

	/**
	 * Sets the class.
	 *
	 * @param type Description is currently not available!
	 */
	protected void setClass( Class<?> type ) {
		_type = type;
	}

	/**
	 * Sets the class descriptor.
	 *
	 * @param classDescriptor Description is currently not available!
	 */
	protected void setClassDescriptor( InstanceDescriptor classDescriptor ) {
		_type = classDescriptor.getType();
		_instanceId = classDescriptor.getInstanceId();
	}

	/**
	 * Sets the instance id.
	 *
	 * @param instanceId Description is currently not available!
	 */
	protected void setInstanceId( String instanceId ) {
		_instanceId = instanceId;
	}

	/**
	 * Same as {@link Clearable#clear()}.
	 */
	protected void clear() {
		_instanceId = null;
		_type = null;
	}
}
