// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.remoting;

/**
 * The Class InvalidMethodRequestRuntimeException.
 */
public class InvalidMethodRequestRuntimeException extends RemotingRuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new invalid method request runtime exception.
	 *
	 * @param aMessage the a message
	 * @param aErrorCode the a error code
	 */
	public InvalidMethodRequestRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new invalid method request runtime exception.
	 *
	 * @param aMessage the a message
	 * @param aCause the a cause
	 * @param aErrorCode the a error code
	 */
	public InvalidMethodRequestRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new invalid method request runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public InvalidMethodRequestRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new invalid method request runtime exception.
	 *
	 * @param message the message
	 */
	public InvalidMethodRequestRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new invalid method request runtime exception.
	 *
	 * @param aCause the a cause
	 * @param aErrorCode the a error code
	 */
	public InvalidMethodRequestRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new invalid method request runtime exception.
	 *
	 * @param cause the cause
	 */
	public InvalidMethodRequestRuntimeException( Throwable cause ) {
		super( cause );
	}
}
