// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import java.io.Serializable;

/**
 * The Class MethodReplyMessageImpl.
 */
class MethodReplyMessageImpl extends ReplyDescriptorImpl implements MethodReplyMessage, Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new {@link MethodReplyMessage} instance.
	 */
	public MethodReplyMessageImpl() {}

	/**
	 * Creates a new {@link MethodReplyMessage} instance.
	 * 
	 * @param aReplyDescriptor The {@link Reply} for the method reply in
	 *        question.
	 */
	public MethodReplyMessageImpl( Reply aReplyDescriptor ) {
		this( aReplyDescriptor.getReturnValue(), aReplyDescriptor.getException(), aReplyDescriptor.getSessionId(), aReplyDescriptor.getInstanceId() );
	}

	/**
	 * Instantiates a new method reply message impl.
	 *
	 * @param aReturnValue the a return value
	 * @param aException the a exception
	 * @param aMethodRequestDescriptor the a method request descriptor
	 */
	public MethodReplyMessageImpl( Object aReturnValue, Throwable aException, MethodRequest aMethodRequestDescriptor ) {
		super( aReturnValue, aException, aMethodRequestDescriptor );
	}

	/**
	 * Instantiates a new method reply message impl.
	 *
	 * @param returnValue the return value
	 * @param throwable the throwable
	 * @param instanceId the instance id
	 * @param sessionId the session id
	 */
	public MethodReplyMessageImpl( Object returnValue, Throwable throwable, String instanceId, String sessionId ) {
		super( returnValue, throwable, instanceId, sessionId );
	}

	/**
	 * Instantiates a new method reply message impl.
	 *
	 * @param instanceId the instance id
	 * @param sessionId the session id
	 */
	public MethodReplyMessageImpl( String instanceId, String sessionId ) {
		super( instanceId, sessionId );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void reset() {
		clear();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setReply( Reply methodReply ) {
		super.setReply( methodReply );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setReturnValue( Object returnValue ) {
		super.setReturnValue( returnValue );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setException( Throwable throwable ) {
		super.setException( throwable );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setInstanceId( String instanceId ) {
		super.setInstanceId( instanceId );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSessionId( String sessionId ) {
		super.setSessionId( sessionId );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMethodReplyDescriptor( Reply methodReplyDescriptor ) {
		super.setMethodReplyDescriptor( methodReplyDescriptor );
	}
}
