// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import java.io.Serializable;

import org.refcodes.mixin.TimeoutInMsAccessor.TimeoutInMsProperty;

/**
 * The Class SignoffSubjectMessageImpl.
 */
class SignoffSubjectMessageImpl extends InstanceDescriptorImpl implements SignOffSubjectMessage, Serializable, TimeoutInMsProperty {

	private static final long serialVersionUID = 1L;

	private long _timeoutInMs;

	/**
	 * {@inheritDoc}.
	 */
	public SignoffSubjectMessageImpl() {
		super();
	}

	/**
	 * Instantiates a new signoff subject message impl.
	 *
	 * @param aInstanceDescriptor the a instance descriptor
	 */
	public SignoffSubjectMessageImpl( InstanceId aInstanceDescriptor ) {
		super( aInstanceDescriptor.getInstanceId() );
	}

	/**
	 * Instantiates a new signoff subject message impl.
	 *
	 * @param aInstanceId the a instance id
	 */
	public SignoffSubjectMessageImpl( String aInstanceId ) {
		super( aInstanceId );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setInstanceId( String instanceId ) {
		super.setInstanceId( instanceId );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public long getTimeoutInMs() {
		return _timeoutInMs;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTimeoutInMs( long aTimeOutInMs ) {
		_timeoutInMs = aTimeOutInMs;
	}
}
