/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.OpenException;
import org.refcodes.exception.VetoException;
import org.refcodes.io.DatagramTransceiver;
import org.refcodes.io.PrefetchBidirectionalStreamConnectionTransceiverImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.remoting.RemoteClientImpl;
import org.refcodes.remoting.RemoteServerImpl;

public class IoStreamRemoteTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int ITERARTIONS = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIoStreamRemote() throws VetoException, OpenException, IOException {
        PipedInputStream theClientInputStream = new PipedInputStream();
        PipedOutputStream theServerOutputStream = new PipedOutputStream(theClientInputStream);
        PipedInputStream theServerInputStream = new PipedInputStream();
        PipedOutputStream theClientOutputStream = new PipedOutputStream(theServerInputStream);
        PrefetchBidirectionalStreamConnectionTransceiverImpl theClientTransceiver = new PrefetchBidirectionalStreamConnectionTransceiverImpl();
        PrefetchBidirectionalStreamConnectionTransceiverImpl theServerTransceiver = new PrefetchBidirectionalStreamConnectionTransceiverImpl();
        ObjectOutputStream theClientObjectOutputStream = new ObjectOutputStream(theClientOutputStream);
        theClientObjectOutputStream.flush();
        ObjectOutputStream theServerObjectOutputStream = new ObjectOutputStream(theServerOutputStream);
        theServerObjectOutputStream.flush();
        theClientTransceiver.open((InputStream)theClientInputStream, (OutputStream)theClientObjectOutputStream);
        theServerTransceiver.open((InputStream)theServerInputStream, (OutputStream)theServerObjectOutputStream);
        RemoteClientImpl theClientRemote = new RemoteClientImpl();
        theClientRemote.open((DatagramTransceiver)theClientTransceiver);
        RemoteServerImpl theServerRemote = new RemoteServerImpl();
        theServerRemote.open((DatagramTransceiver)theServerTransceiver);
        ArrayList<String> thePublishedList = new ArrayList<String>();
        thePublishedList.add("A");
        thePublishedList.add("B");
        thePublishedList.add("C");
        Iterator e = thePublishedList.iterator();
        while (e.hasNext()) {
            LOGGER.info("Before published = " + (String)e.next());
        }
        theServerRemote.publishSubject(thePublishedList);
        IoStreamRemoteTest ioStreamRemoteTest = this;
        synchronized (ioStreamRemoteTest) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object theProxy = theClientRemote.proxies().next();
        LOGGER.info("Proxy class = " + theProxy.getClass());
        if (theProxy instanceof List) {
            List theProxyList = (List)theProxy;
            theProxyList.add("1");
            theProxyList.add("2");
            theProxyList.add("3");
            IoStreamRemoteTest ioStreamRemoteTest2 = this;
            synchronized (ioStreamRemoteTest2) {
                this.notifyAll();
            }
        }
        e = thePublishedList.iterator();
        while (e.hasNext()) {
            LOGGER.info("After published = " + (String)e.next());
        }
        Assertions.assertTrue((boolean)thePublishedList.contains("1"));
        Assertions.assertTrue((boolean)thePublishedList.contains("2"));
        Assertions.assertTrue((boolean)thePublishedList.contains("3"));
        Assertions.assertTrue((boolean)thePublishedList.contains("A"));
        Assertions.assertTrue((boolean)thePublishedList.contains("B"));
        Assertions.assertTrue((boolean)thePublishedList.contains("C"));
        theServerRemote.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStressIoStreamRemote() throws UnknownHostException, IOException, OpenException {
        PipedInputStream theClientStream = new PipedInputStream();
        PipedOutputStream theServerOutputStream = new PipedOutputStream(theClientStream);
        PipedInputStream theServerInputStream = new PipedInputStream();
        PipedOutputStream theClientOutputStream = new PipedOutputStream(theServerInputStream);
        PrefetchBidirectionalStreamConnectionTransceiverImpl theClientTransceiver = new PrefetchBidirectionalStreamConnectionTransceiverImpl();
        PrefetchBidirectionalStreamConnectionTransceiverImpl theServerTransceiver = new PrefetchBidirectionalStreamConnectionTransceiverImpl();
        ObjectOutputStream theClientObjectOutputStream = new ObjectOutputStream(theClientOutputStream);
        theClientObjectOutputStream.flush();
        ObjectOutputStream theServerObjectOutputStream = new ObjectOutputStream(theServerOutputStream);
        theServerObjectOutputStream.flush();
        theClientTransceiver.open((InputStream)theClientStream, (OutputStream)theClientObjectOutputStream);
        theServerTransceiver.open((InputStream)theServerInputStream, (OutputStream)theServerObjectOutputStream);
        RemoteClientImpl theClientRemote = new RemoteClientImpl();
        theClientRemote.open((DatagramTransceiver)theClientTransceiver);
        RemoteServerImpl theServerRemote = new RemoteServerImpl();
        theServerRemote.open((DatagramTransceiver)theServerTransceiver);
        CountingList<String> theList = new CountingList<String>();
        theList.add("A");
        theList.add("B");
        theList.add("C");
        Assertions.assertEquals((int)3, (int)theList.getAddCount());
        Iterator e = theList.iterator();
        while (e.hasNext()) {
            LOGGER.info("Before published = " + (String)e.next());
        }
        theServerRemote.publishSubject(theList);
        IoStreamRemoteTest ioStreamRemoteTest = this;
        synchronized (ioStreamRemoteTest) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object theProxy = theClientRemote.proxies().next();
        LOGGER.info("Proxy class = " + theProxy.getClass());
        if (theProxy instanceof List) {
            int i;
            List theProxyList = (List)theProxy;
            LOGGER.info("Perforimg ADD operations:");
            for (i = 0; i < 1000; ++i) {
                if (i % 10 == 0) {
                    LOGGER.info("ADD(" + i + ")");
                }
                theProxyList.add("" + i);
                Assertions.assertTrue((boolean)theProxyList.contains("" + i));
            }
            LOGGER.info("Perforimg REMOVE operations:");
            for (i = 0; i < 1000; ++i) {
                if (i % 10 == 0) {
                    LOGGER.info("REMOVE(" + i + ")");
                }
                theProxyList.remove("" + i);
                Assertions.assertFalse((boolean)theProxyList.contains("" + i));
            }
            Assertions.assertFalse((boolean)theProxyList.isEmpty());
            Assertions.assertTrue((boolean)theProxyList.contains("A"));
            Assertions.assertTrue((boolean)theProxyList.contains("B"));
            Assertions.assertTrue((boolean)theProxyList.contains("C"));
            theProxyList.clear();
            Assertions.assertTrue((boolean)theProxyList.isEmpty());
            IoStreamRemoteTest ioStreamRemoteTest2 = this;
            synchronized (ioStreamRemoteTest2) {
                this.notifyAll();
            }
        }
        e = theList.iterator();
        while (e.hasNext()) {
            LOGGER.info("After published = " + (String)e.next());
        }
        Assertions.assertTrue((boolean)theList.isEmpty());
        Assertions.assertEquals((int)1003, (int)theList.getAddCount());
        Assertions.assertEquals((int)1000, (int)theList.getRemoveCount());
        Assertions.assertEquals((int)1, (int)theList.getClearCount());
        theServerRemote.close();
    }

    public class CountingList<T>
    extends ArrayList<T>
    implements List<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int _addCount = 0;
        private int _removeCount = 0;
        private int _clearCount = 0;

        @Override
        public boolean add(T o) {
            boolean isAdd = super.add(o);
            ++this._addCount;
            return isAdd;
        }

        @Override
        public void clear() {
            super.clear();
            ++this._clearCount;
        }

        @Override
        public boolean remove(Object o) {
            boolean isRemove = super.remove(o);
            ++this._removeCount;
            return isRemove;
        }

        public int getAddCount() {
            return this._addCount;
        }

        public int getRemoveCount() {
            return this._removeCount;
        }

        public int getClearCount() {
            return this._clearCount;
        }
    }
}

