/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.DigestException;
import org.refcodes.component.OpenException;
import org.refcodes.component.OpenTimeoutException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeoutImpl;
import org.refcodes.data.IoTimeout;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.exception.VetoException;
import org.refcodes.generator.Generator;
import org.refcodes.generator.UniqueIdGeneratorImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.BusyAccessor;
import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.DisposedAccessor;
import org.refcodes.mixin.Lockable;
import org.refcodes.remoting.AbstractRemote;
import org.refcodes.remoting.AmbiguousProxyException;
import org.refcodes.remoting.CancelMethodReplyMessage;
import org.refcodes.remoting.CancelMethodReplyMessageImpl;
import org.refcodes.remoting.CloseConnectionMessage;
import org.refcodes.remoting.DuplicateInstanceIdRuntimeException;
import org.refcodes.remoting.DuplicateSessionIdRuntimeException;
import org.refcodes.remoting.InstanceDescriptor;
import org.refcodes.remoting.InstanceId;
import org.refcodes.remoting.InvalidMethodReplyRuntimeException;
import org.refcodes.remoting.Message;
import org.refcodes.remoting.MethodReplyMessage;
import org.refcodes.remoting.MethodRequest;
import org.refcodes.remoting.MethodRequestDescriptorImpl;
import org.refcodes.remoting.MethodRequestMessageImpl;
import org.refcodes.remoting.NoSuchProxyException;
import org.refcodes.remoting.ProxyDescriptor;
import org.refcodes.remoting.ProxyDescriptorImpl;
import org.refcodes.remoting.ProxyDisposedRuntimeException;
import org.refcodes.remoting.PublishSubjectMessage;
import org.refcodes.remoting.PublishSubjectReplyMessageImpl;
import org.refcodes.remoting.RemoteClient;
import org.refcodes.remoting.Reply;
import org.refcodes.remoting.ReplyDescriptorImpl;
import org.refcodes.remoting.SignOffProxyMessageImpl;
import org.refcodes.remoting.SignOffSubjectMessage;
import org.refcodes.remoting.UnknownInstanceIdRuntimeException;

public class RemoteClientImpl
extends AbstractRemote
implements RemoteClient {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private InstanceHandler _instanceHandler = new InstanceHandler();

    public RemoteClientImpl() {
    }

    public RemoteClientImpl(ExecutorService aExecutorService) {
        super(aExecutorService);
    }

    public void clear() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        this.signOffAllProxies();
    }

    @Override
    public synchronized void close() {
        LOGGER.info("CLOSE called on <" + this.getClass().getName() + ">.");
        this.close(null);
    }

    public boolean isBusy() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.isBusy();
    }

    @Override
    public boolean hasProxy(Object proxy) {
        return this.getProxyDescriptor(proxy) != null;
    }

    @Override
    public <T> T getProxy(Class<T> aType) throws AmbiguousProxyException, NoSuchProxyException {
        Iterator<Object> e = this.proxies();
        Object theProxy = null;
        while (e.hasNext()) {
            Object eProxy = e.next();
            if (!aType.isAssignableFrom(eProxy.getClass())) continue;
            if (theProxy != null) {
                throw new AmbiguousProxyException("More than one proxy matching the given class \"" + aType.getName() + "\" found; an ambigous state detected; only one proxy must match your type!");
            }
            theProxy = eProxy;
        }
        if (theProxy == null) {
            throw new NoSuchProxyException("Not one proxy matching the given class \"" + aType.getName() + "\" found; exactly one proxy must match your type!");
        }
        return (T)theProxy;
    }

    @Override
    public boolean hasProxy(Class<?> aType) {
        Iterator<Object> e = this.proxies();
        while (e.hasNext()) {
            Object eProxy = e.next();
            if (!aType.isAssignableFrom(eProxy.getClass())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> proxies() {
        ControlFlowUtility.throwIllegalStateException((this.isDestroyed() && !this.isOpened() ? 1 : 0) != 0);
        ArrayList<Object> theProxyList = new ArrayList<Object>(this._instanceHandler.size());
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            Iterator<ProxyDescriptor> e = this._instanceHandler.proxyDescriptors();
            while (e.hasNext()) {
                theProxyList.add(e.next().getProxy());
            }
        }
        return theProxyList.iterator();
    }

    public boolean isEmpty() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean signOffProxy(Object aProxy) throws OpenException {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        if (aProxy == null) {
            return false;
        }
        ProxyDescriptor theProxyDescriptor = this.getProxyDescriptor(aProxy);
        if (theProxyDescriptor == null) {
            return false;
        }
        String theInstanceId = theProxyDescriptor.getInstanceId();
        if (!this.isClosed()) {
            if (theProxyDescriptor.getInstanceId() == null) {
                return false;
            }
            if (this._instanceHandler.hasSignedOffInstanceId(theInstanceId)) {
                return false;
            }
            if (!this._instanceHandler.hasProxyControl(theInstanceId)) {
                return false;
            }
        }
        RemoteClient.ProxyControl theProxyControl = this._instanceHandler.getProxyControl(theInstanceId);
        this.onProxySignedOff(theProxyDescriptor.getProxy());
        theProxyControl.lock();
        this.waitForActiveSessions(theProxyControl);
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            if (this._instanceHandler.hasSignedOffInstanceId(theInstanceId)) {
                return false;
            }
            theProxyControl = this._instanceHandler.getProxyControl(theInstanceId);
            this._instanceHandler.removeProxyDescriptor(theInstanceId);
            if (this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
                theProxyControl.dispose();
                throw new DuplicateInstanceIdRuntimeException("The instance of the provided <GenericInstanceDescriptor> object in arguemnt <proxyDescriptor> is already in use and being calluted. Sorry - aborting operation !!!");
            }
        }
        SignOffProxyMessageImpl theSignOffProxyJob = new SignOffProxyMessageImpl();
        theSignOffProxyJob.setInstanceId(theProxyDescriptor.getInstanceId());
        CancelMethodReplyMessageImpl theCancelMethodReplyJobImpl = new CancelMethodReplyMessageImpl();
        theCancelMethodReplyJobImpl.setInstanceId(theInstanceId);
        theCancelMethodReplyJobImpl.setHasReply(false);
        this._instanceHandler.addReplyDescriptor(theCancelMethodReplyJobImpl, theInstanceId);
        try {
            this.toReceiver(theSignOffProxyJob);
        }
        catch (OpenException aException) {
            theProxyControl.dispose();
            theProxyControl.unlock();
            this._instanceHandler.removeMethodReplyDescriptor(theInstanceId);
            if (aException.getCause() instanceof IOException) {
                this.closeOnException();
            }
            throw aException;
        }
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(30000L, 250);
        while (!theCancelMethodReplyJobImpl.hasReply() && theRetryTimeout.hasNextRetry() && this.isOpened() && !theProxyControl.isDisposed()) {
            LOGGER.info("Wait loop <" + theRetryTimeout.getRetryCount() + "> while waiting for method reply for <" + 250 + "> ms; connection status is " + this.getConnectionStatus() + ".");
            theRetryTimeout.nextRetry((Object)theCancelMethodReplyJobImpl);
        }
        theProxyControl.dispose();
        this._instanceHandler.removeMethodReplyDescriptor(theInstanceId);
        if (!theCancelMethodReplyJobImpl.hasReply()) {
            throw new OpenTimeoutException(30000L, "While processing the request a timeout of 30000 ms has been overshot! Propably lost the connection (you propably should close the connection). Sorry - request aborted!");
        }
        if (theCancelMethodReplyJobImpl.isReturnValue() && theCancelMethodReplyJobImpl.getReturnValue() instanceof Boolean) {
            boolean returnValue = (Boolean)theCancelMethodReplyJobImpl.getReturnValue();
            if (returnValue) {
                theProxyControl.dispose();
            }
            return returnValue;
        }
        throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a class descripter.");
    }

    public int size() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.size();
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyed()) {
            super.destroy();
            this.close();
            this._instanceHandler.clear();
            this._instanceHandler = null;
        }
    }

    void pushMethodReply(Reply aMethodReply) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        RemoteClient.ProxyControl theProxyControl = this._instanceHandler.getProxyControl(aMethodReply.getInstanceId());
        if (theProxyControl == null) {
            throw new IllegalArgumentException("Unable to retrieve the the proxy control assosiated the instance ID <" + aMethodReply.getInstanceId() + "> of the given  method reply.");
        }
        theProxyControl.pushMethodReply(aMethodReply);
    }

    protected void doSendJob(Message aJob) throws OpenException {
        this.toReceiver(aJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void digest(Message aJob) throws DigestException {
        block18: {
            try {
                if (aJob == null) {
                    return;
                }
                if (aJob instanceof CloseConnectionMessage) {
                    LOGGER.info("Received a close connection job to <" + this.getClass().getName() + ">; closing connection.");
                    this.close((CloseConnectionMessage)aJob);
                    break block18;
                }
                if (aJob instanceof CancelMethodReplyMessage) {
                    CancelMethodReplyMessage replyRemotorJob = (CancelMethodReplyMessage)aJob;
                    if (replyRemotorJob.getInstanceId() == null) {
                        return;
                    }
                    String aInstanceId = replyRemotorJob.getInstanceId();
                    if (!this._instanceHandler.hasMethodReplyDescriptor(aInstanceId)) {
                        throw new UnknownInstanceIdRuntimeException("Unkwnown instance ID <" + aInstanceId + ">, expected a known instance ID.");
                    }
                    Reply tmpReply = this._instanceHandler.getMethodReplyDescriptor(aInstanceId);
                    if (!(tmpReply instanceof CancelMethodReplyMessage)) {
                        throw new InvalidMethodReplyRuntimeException("Excpected a \"" + CancelMethodReplyMessage.class.getName() + "\".");
                    }
                    CancelMethodReplyMessage waitingReplyRemotorJob = (CancelMethodReplyMessage)tmpReply;
                    waitingReplyRemotorJob.setReply(replyRemotorJob);
                    CancelMethodReplyMessage cancelMethodReplyMessage = waitingReplyRemotorJob;
                    synchronized (cancelMethodReplyMessage) {
                        waitingReplyRemotorJob.notifyAll();
                        break block18;
                    }
                }
                if (aJob instanceof MethodReplyMessage) {
                    this.pushMethodReply((Reply)((Object)aJob));
                } else if (aJob instanceof PublishSubjectMessage) {
                    try {
                        boolean returnValue = this.publishClassDescriptor((InstanceDescriptor)((Object)aJob));
                        PublishSubjectReplyMessageImpl thePublishSubjectReplyJob = new PublishSubjectReplyMessageImpl();
                        thePublishSubjectReplyJob.setInstanceId(aJob.getInstanceId());
                        thePublishSubjectReplyJob.setException(null);
                        thePublishSubjectReplyJob.setReturnValue(new Boolean(returnValue));
                        thePublishSubjectReplyJob.setHasReply(true);
                        this.toReceiver(thePublishSubjectReplyJob);
                    }
                    catch (VetoException aException) {
                        PublishSubjectReplyMessageImpl theMethodReplyJob = new PublishSubjectReplyMessageImpl();
                        theMethodReplyJob.setInstanceId(aJob.getInstanceId());
                        theMethodReplyJob.setException((Exception)((Object)aException));
                        theMethodReplyJob.setReturnValue(null);
                        theMethodReplyJob.setHasReply(false);
                        this.toReceiver(theMethodReplyJob);
                    }
                } else if (aJob instanceof SignOffSubjectMessage) {
                    Message theInstanceDescriptor = aJob;
                    boolean isSignOff = this.signoffInstanceDescriptor(theInstanceDescriptor);
                    PublishSubjectReplyMessageImpl theMethodReplyJob = new PublishSubjectReplyMessageImpl();
                    theMethodReplyJob.setInstanceId(aJob.getInstanceId());
                    theMethodReplyJob.setReturnValue(new Boolean(isSignOff));
                    theMethodReplyJob.setException(null);
                    theMethodReplyJob.setHasReply(true);
                    this.toReceiver(theMethodReplyJob);
                }
            }
            catch (OpenException aException) {
                this.closeOnException();
                throw new DigestException("Digesting the job caued a cause exception to be thrown.", (Throwable)aException);
            }
        }
    }

    @Override
    protected synchronized void close(CloseConnectionMessage aJob) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        LOGGER.info("CLOSE called on <" + this.getClass().getName() + "> with job <" + aJob + ">; connection status is " + this.getConnectionStatus() + ".");
        if (!this.isClosed()) {
            this.signOffAllProxies();
            this._instanceHandler.lock();
            RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl((long)IoTimeout.NORM.getMilliseconds(), RetryLoopCount.NORM_NUM_RETRY_LOOPS.getNumber().intValue());
            while (this.isBusy() && theRetryTimeout.hasNextRetry()) {
                LOGGER.info("Wait loop <" + theRetryTimeout.getRetryCount() + "> while being BUSY for <" + LoopSleepTime.NORM.getMilliseconds() + "> ms.");
                theRetryTimeout.nextRetry();
            }
            super.close(aJob);
            if (this.isBusy()) {
                LOGGER.warn("Still being BUSY even after reaching the timeout of <" + IoTimeout.NORM.getMilliseconds() + "> ms, closing connection nonetheless.");
            }
            try {
                super.close();
            }
            catch (CloseException e) {
                LOGGER.warn("Unable to close malfunctioning connection.", (Throwable)e);
            }
            this.onClosed();
        }
    }

    protected void onPublishProxy(Class<?> aType) throws VetoException {
    }

    protected void onProxyPublished(Object aProxy) {
    }

    protected void onProxySignedOff(Object aProxy) {
    }

    void pushMethodRequest(MethodRequest aMethodRequestDescriptor) throws OpenException {
        MethodRequestMessageImpl theMethodRequestJob = new MethodRequestMessageImpl();
        theMethodRequestJob.setMethodRequestDescriptor(aMethodRequestDescriptor);
        this.toReceiver(theMethodRequestJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOnException() {
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            Iterator<ProxyDescriptor> e = this._instanceHandler.proxyDescriptors();
            while (e.hasNext()) {
                ProxyDescriptor eProxyDescriptor = e.next();
                RemoteClient.ProxyControl eProxyControl = this._instanceHandler.getProxyControl(eProxyDescriptor.getInstanceId());
                if (eProxyControl != null) {
                    eProxyControl.dispose();
                }
                this.onProxySignedOff(eProxyDescriptor.getProxy());
            }
        }
        this._instanceHandler.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signOffAllProxies() {
        boolean hasException = false;
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            Iterator<RemoteClient.ProxyControl> e = this._instanceHandler.proxyControls();
            while (e.hasNext()) {
                RemoteClient.ProxyControl eProxyControl = e.next();
                try {
                    this.signOffProxy(eProxyControl.getProxy());
                }
                catch (OpenException aException) {
                    hasException = true;
                }
            }
            if (hasException) {
                this.clearOnException();
            }
            this._instanceHandler.clear();
        }
    }

    private void closeOnException() {
        this.clearOnException();
        try {
            super.close();
        }
        catch (CloseException e) {
            LOGGER.warn("Unable to close malfunctioning connection.", (Throwable)e);
        }
        this.onClosed();
    }

    private boolean publishClassDescriptor(InstanceDescriptor aClassDescriptor) throws VetoException {
        assert (aClassDescriptor != null);
        assert (aClassDescriptor.getInstanceId() != null);
        if (this._instanceHandler.hasProxyControl(aClassDescriptor.getInstanceId())) {
            throw new DuplicateInstanceIdRuntimeException("The instance ID <" + aClassDescriptor.getInstanceId() + "> of the given class descriptor is already in use.");
        }
        String aInstanceId = aClassDescriptor.getInstanceId();
        this.onPublishProxy(aClassDescriptor.getType());
        ProxyControlImpl theProxyControl = new ProxyControlImpl(aClassDescriptor);
        ProxyDescriptorImpl proxyDescriptor = new ProxyDescriptorImpl(aClassDescriptor, theProxyControl.getProxy());
        this._instanceHandler.addProxyControl(theProxyControl, aInstanceId);
        this._instanceHandler.addProxyDescriptor(proxyDescriptor, aInstanceId);
        this.onProxyPublished(proxyDescriptor.getProxy());
        return true;
    }

    private boolean signoffInstanceDescriptor(InstanceId aInstanceDescriptor) {
        if (aInstanceDescriptor == null) {
            throw new NullPointerException("Expected an object of type <GenericInstanceDescriptor> instead of a null value in argument <instanceDescriptor>.");
        }
        if (aInstanceDescriptor.getInstanceId() == null) {
            throw new NullPointerException("Expected an object of type <String> instead of a null value when retrieving the instance ID of argument <instanceDescriptor>.");
        }
        String aInstanceId = aInstanceDescriptor.getInstanceId();
        if (this._instanceHandler.hasSignedOffInstanceId(aInstanceId)) {
            return true;
        }
        if (!this._instanceHandler.hasProxyControl(aInstanceId)) {
            throw new UnknownInstanceIdRuntimeException("Expected a known instance ID in argument <instanceDescriptor>.");
        }
        ProxyDescriptor theProxyDescriptor = this._instanceHandler.getProxyDescriptor(aInstanceId);
        ProxyControlImpl theProxyControl = (ProxyControlImpl)this._instanceHandler.getProxyControl(aInstanceId);
        this.onProxySignedOff(theProxyDescriptor.getProxy());
        theProxyControl.lock();
        this.waitForActiveSessions(theProxyControl);
        this._instanceHandler.removeProxyDescriptor(aInstanceId);
        theProxyControl.dispose();
        return true;
    }

    private void waitForActiveSessions(RemoteClient.ProxyControl aProxyControl) {
        RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl(20000L, 250);
        while (aProxyControl.isBusy() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
            LOGGER.info("Wait loop <" + theRetryTimeout.getRetryCount() + "> while proxy \"" + aProxyControl.getProxy() + "\" (<" + aProxyControl.getClass() + ">) having ACTIVE SESSIONS for <" + 250 + "> ms.");
            theRetryTimeout.nextRetry((Object)aProxyControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyDescriptor getProxyDescriptor(Object aProxy) {
        ControlFlowUtility.throwIllegalStateException((this.isDestroyed() && !this.isOpened() ? 1 : 0) != 0);
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            Iterator<ProxyDescriptor> e = this._instanceHandler.proxyDescriptors();
            while (e.hasNext()) {
                ProxyDescriptor eProxyDescriptor = e.next();
                if (eProxyDescriptor.getProxy() != aProxy) continue;
                return eProxyDescriptor;
            }
        }
        return null;
    }

    private class InstanceHandler
    implements Lockable,
    BusyAccessor {
        private HashMap<String, RemoteClient.ProxyControl> _instanceIdsToProxyControl = new HashMap();
        private HashMap<String, ProxyDescriptor> _instanceIdsToProxyDescriptor = new HashMap();
        private HashMap<String, Reply> _instanceIdsToMethodReplyDescriptor = new HashMap();
        private Set<String> _signedOffInstanceIds = Collections.newSetFromMap(new WeakHashMap());

        private InstanceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addProxyControl(RemoteClient.ProxyControl aProxyControl, String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (this.hasProxyControl(aInstanceId)) {
                    return false;
                }
                this._instanceIdsToProxyControl.put(aInstanceId, aProxyControl);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addProxyDescriptor(ProxyDescriptor aPreoxyDescriptor, String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (this.hasProxyDescriptor(aInstanceId)) {
                    return false;
                }
                this._instanceIdsToProxyDescriptor.put(aInstanceId, aPreoxyDescriptor);
            }
            return true;
        }

        boolean addReplyDescriptor(Reply aMethodReplyDescriptor, String aInstanceId) {
            if (this.hasMethodReplyDescriptor(aInstanceId)) {
                return false;
            }
            this._instanceIdsToMethodReplyDescriptor.put(aInstanceId, aMethodReplyDescriptor);
            return true;
        }

        synchronized void clear() {
            this._instanceIdsToProxyControl.clear();
            this._instanceIdsToProxyDescriptor.clear();
            this._instanceIdsToMethodReplyDescriptor.clear();
            this._signedOffInstanceIds.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RemoteClient.ProxyControl getProxyControl(String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (!this.hasProxyControl(aInstanceId)) {
                    return null;
                }
            }
            return this._instanceIdsToProxyControl.get(aInstanceId);
        }

        ProxyDescriptor getProxyDescriptor(String aInstanceId) {
            if (!this.hasProxyDescriptor(aInstanceId)) {
                return null;
            }
            return this._instanceIdsToProxyDescriptor.get(aInstanceId);
        }

        Reply getMethodReplyDescriptor(String aInstanceId) {
            if (!this.hasMethodReplyDescriptor(aInstanceId)) {
                return null;
            }
            return this._instanceIdsToMethodReplyDescriptor.get(aInstanceId);
        }

        boolean hasProxyControl(String aInstanceId) {
            return this._instanceIdsToProxyControl.containsKey(aInstanceId);
        }

        boolean hasProxyDescriptor(String aInstanceId) {
            return this._instanceIdsToProxyDescriptor.containsKey(aInstanceId);
        }

        boolean hasMethodReplyDescriptor(String aInstanceId) {
            return this._instanceIdsToMethodReplyDescriptor.containsKey(aInstanceId);
        }

        boolean hasSignedOffInstanceId(String aInstanceId) {
            return this._signedOffInstanceIds.contains(aInstanceId);
        }

        synchronized Iterator<RemoteClient.ProxyControl> proxyControls() {
            return new ArrayList<RemoteClient.ProxyControl>(this._instanceIdsToProxyControl.values()).iterator();
        }

        Iterator<ProxyDescriptor> proxyDescriptors() {
            return this._instanceIdsToProxyDescriptor.values().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProxyDescriptor removeProxyDescriptor(String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (!this.hasProxyDescriptor(aInstanceId)) {
                    return null;
                }
                if (!this.hasProxyControl(aInstanceId)) {
                    return null;
                }
                if (this.hasSignedOffInstanceId(aInstanceId)) {
                    return null;
                }
                this.addSignedOffInstanceId(aInstanceId);
                this.removeProxyControl(aInstanceId);
                return this._instanceIdsToProxyDescriptor.remove(aInstanceId);
            }
        }

        Reply removeMethodReplyDescriptor(String aInstanceId) {
            if (!this.hasMethodReplyDescriptor(aInstanceId)) {
                return null;
            }
            return this._instanceIdsToMethodReplyDescriptor.remove(aInstanceId);
        }

        int size() {
            return this._instanceIdsToProxyDescriptor.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addSignedOffInstanceId(String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                return this._signedOffInstanceIds.add(aInstanceId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RemoteClient.ProxyControl removeProxyControl(String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                if (!this.hasProxyControl(aInstanceId)) {
                    return null;
                }
                return this._instanceIdsToProxyControl.remove(aInstanceId);
            }
        }

        boolean isEmpty() {
            return this._instanceIdsToProxyDescriptor.isEmpty();
        }

        public synchronized boolean isBusy() {
            if (!this._instanceIdsToMethodReplyDescriptor.isEmpty()) {
                return false;
            }
            Iterator<RemoteClient.ProxyControl> e = this.proxyControls();
            while (e.hasNext()) {
                RemoteClient.ProxyControl eProxyControl = e.next();
                if (!eProxyControl.isBusy()) continue;
                return true;
            }
            return false;
        }

        public synchronized void lock() {
            Iterator<RemoteClient.ProxyControl> e = this.proxyControls();
            while (e.hasNext()) {
                e.next().lock();
            }
        }

        public synchronized void unlock() {
            Iterator<RemoteClient.ProxyControl> e = this.proxyControls();
            while (e.hasNext()) {
                e.next().unlock();
            }
        }

        public synchronized boolean isLocked() {
            Iterator<RemoteClient.ProxyControl> e = this.proxyControls();
            while (e.hasNext()) {
                if (e.next().isLocked()) continue;
                return false;
            }
            return true;
        }
    }

    private class ProxyControlImpl
    implements RemoteClient.ProxyControl {
        private static final boolean IS_THROW_UNKNOWN_INSTANCE_ID_EXCETIONS_ENABLED = false;
        private InstanceDescriptor _classDescriptor;
        private int _hasActiveSessionsCount = 0;
        private boolean _isDisposeable = false;
        private boolean _isLocked = false;
        private boolean _isProxyDisposed = false;
        private Object _proxy;
        private Generator<String> _sessionIdGenerator = new UniqueIdGeneratorImpl(32);
        private Map<String, Reply> _sessionIds2MethodReply = new HashMap<String, Reply>();

        ProxyControlImpl(InstanceDescriptor aClassDescriptor) {
            int length = aClassDescriptor.getType().getInterfaces().length;
            Class<?>[] interfaceArray = aClassDescriptor.getType().getInterfaces();
            Class[] proxyInterfaceArray = new Class[length + 2];
            for (int i = 0; i < length; ++i) {
                proxyInterfaceArray[i] = interfaceArray[i];
            }
            proxyInterfaceArray[length] = DisposedAccessor.class;
            proxyInterfaceArray[length + 1] = Disposable.Disposedable.class;
            if (Disposable.Disposedable.class.isAssignableFrom(aClassDescriptor.getType())) {
                this._isDisposeable = true;
            }
            this._proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), proxyInterfaceArray, (InvocationHandler)this);
            this._classDescriptor = aClassDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Object p = this.getProxy();
            synchronized (p) {
                this._isProxyDisposed = true;
            }
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public InstanceDescriptor getClassDescriptor() {
            return this._classDescriptor;
        }

        @Override
        public String getInstanceId() {
            return this._classDescriptor.getInstanceId();
        }

        @Override
        public <P> P getProxy() {
            return (P)this._proxy;
        }

        @Override
        public boolean isBusy() {
            return this._hasActiveSessionsCount > 0;
        }

        public int hashCode() {
            return super.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            long timeout;
            ++this._hasActiveSessionsCount;
            if (method.getName().equals("equals") && arguments != null && arguments.length == 1) {
                --this._hasActiveSessionsCount;
                return new Boolean(this.getProxy() == arguments[0]);
            }
            if (method.getName().equals("isProxyDisposed") && arguments == null) {
                --this._hasActiveSessionsCount;
                return new Boolean(this.isProxyUnusable());
            }
            if (method.getName().equals("isDisposed") && arguments == null) {
                if (this._isDisposeable) {
                    if (this.isProxyUnusable()) {
                        --this._hasActiveSessionsCount;
                        return new Boolean(true);
                    }
                } else {
                    --this._hasActiveSessionsCount;
                    return new Boolean(this.isProxyUnusable());
                }
            }
            if (method.getName().equals("hashCode") && arguments == null) {
                --this._hasActiveSessionsCount;
                return new Integer(super.hashCode());
            }
            if (this.isProxyUnusable()) {
                if (method.getName().equals("toString") && arguments == null) {
                    --this._hasActiveSessionsCount;
                    return super.toString();
                }
                if (method.getName().equals("isDisposed") && arguments == null) {
                    --this._hasActiveSessionsCount;
                    return new Boolean(true);
                }
                throw new ProxyDisposedRuntimeException("The proxy object <" + this.getClassDescriptor().getType().getName() + "> is disposed!");
            }
            String theSessionId = null;
            Generator<String> generator = this._sessionIdGenerator;
            synchronized (generator) {
                if (!this._sessionIdGenerator.hasNext()) {
                    --this._hasActiveSessionsCount;
                    throw new IllegalStateException("The ID generator is unable to create more unique IDs");
                }
                theSessionId = (String)this._sessionIdGenerator.next();
            }
            if (theSessionId == null) {
                --this._hasActiveSessionsCount;
                throw new IllegalStateException("The ID generator is unable to create more unique IDs");
            }
            ReplyDescriptorImpl methodReply = null;
            Map<String, Reply> map = this._sessionIds2MethodReply;
            synchronized (map) {
                if (this._sessionIds2MethodReply.containsKey(theSessionId)) {
                    --this._hasActiveSessionsCount;
                    throw new DuplicateSessionIdRuntimeException("The session id generator seems to generatoe duplicate id <String> objects. Sorry - aborting operation!");
                }
                String instanceId = this.getInstanceId();
                methodReply = new ReplyDescriptorImpl(instanceId, theSessionId);
                this._sessionIds2MethodReply.put(theSessionId, methodReply);
            }
            MethodRequestDescriptorImpl methodRequest = new MethodRequestDescriptorImpl(method, arguments, this.getInstanceId(), theSessionId);
            RemoteClientImpl.this.pushMethodRequest(methodRequest);
            for (timeout = 30000L; !methodReply.hasReply() && timeout >= 0L && !this.isProxyUnusable() && RemoteClientImpl.this.isOpened(); timeout -= 250L) {
                ReplyDescriptorImpl replyDescriptorImpl = methodReply;
                synchronized (replyDescriptorImpl) {
                    try {
                        if (!methodReply.hasReply() && timeout >= 0L && !this.isProxyUnusable()) {
                            methodReply.wait(250L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            this._sessionIds2MethodReply.remove(theSessionId);
            --this._hasActiveSessionsCount;
            if (!methodReply.hasReply()) {
                if (this.isProxyUnusable()) {
                    throw new ProxyDisposedRuntimeException("The proxy object <" + this.getClassDescriptor().getType().getName() + "> is disposed!");
                }
                if (timeout < 0L) {
                    throw new OpenTimeoutException(30000L, "While processing the request a timeout of 30000 ms has been overshot! Propably lost the connection (you propably should close the connection). Sorry - request aborted!");
                }
                throw new OpenException("The proxy object <" + this.getClassDescriptor().getType().getName() + "> is did not recieve the expected remote reply - unkown cause!");
            }
            if (methodReply.isException()) {
                throw methodReply.getException();
            }
            if (method.getName().equals("equals") && arguments != null && arguments.length == 1 && methodReply.getReturnValue() instanceof Boolean) {
                boolean returnValue = (Boolean)methodReply.getReturnValue();
                return new Boolean(super.equals(arguments[0]) | returnValue);
            }
            return methodReply.getReturnValue();
        }

        public boolean isDisposed() {
            return this.isProxyUnusable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushMethodReply(Reply aMethodReply) {
            if (aMethodReply == null) {
                return;
            }
            if (!this.getInstanceId().equals(aMethodReply.getInstanceId())) {
                if (!this.isProxyUnusable()) {
                    throw new UnknownInstanceIdRuntimeException("The instance id of the <methodReply> argument (<BlueprintMethodReply> object) is not the same as the expected instance id !!! Sorry - aborting operation!");
                }
                return;
            }
            if (!this._sessionIds2MethodReply.containsKey(aMethodReply.getSessionId())) {
                if (!this.isProxyUnusable()) {
                    return;
                }
                return;
            }
            Reply waitingMethodReply = this._sessionIds2MethodReply.remove(aMethodReply.getSessionId());
            if (waitingMethodReply == null) {
                if (!this.isProxyUnusable()) {
                    throw new IllegalStateException("No prepared method reply object found.");
                }
                return;
            }
            waitingMethodReply.setReply(aMethodReply);
            Reply reply = waitingMethodReply;
            synchronized (reply) {
                waitingMethodReply.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            Object p = this.getProxy();
            synchronized (p) {
                this._isLocked = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            Object p = this.getProxy();
            synchronized (p) {
                this._isLocked = false;
            }
        }

        public boolean isLocked() {
            return this._isLocked;
        }

        private boolean isProxyUnusable() {
            return this._isProxyDisposed || this._isLocked || RemoteClientImpl.this.isClosed() || RemoteClientImpl.this.isEmpty();
        }
    }
}

