// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import org.refcodes.mixin.TypeAccessor;

/**
 * The most common information to be provided when describing an object residing
 * in a {@link RemoteServer} and which is linked to a {@link RemoteClient}. The
 * {@link RemoteServer} creates this descriptor and passes it to the
 * {@link RemoteClient}, the {@link RemoteClient} attaches this information to a
 * {@link ProxyDescriptor} describing its proxy instances.
 */
@SuppressWarnings("rawtypes")
public interface InstanceDescriptor extends InstanceId, TypeAccessor {}
