// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

/**
 * Provides an accessor for a {@link InstanceDescriptor} property.
 */
public interface InstanceDescriptorAccessor {

	/**
	 * Retrieves the {@link InstanceDescriptor} from the
	 * {@link InstanceDescriptor} property.
	 * 
	 * @return The {@link InstanceDescriptor} stored by the
	 *         {@link InstanceDescriptor} property.
	 */
	InstanceDescriptor getTypeInstance();

	/**
	 * Provides a mutator for a {@link InstanceDescriptor} property.
	 */
	public interface InstanceDescriptorMutator {

		/**
		 * Sets the {@link InstanceDescriptor} for the
		 * {@link InstanceDescriptor} property.
		 * 
		 * @param aInstanceDescriptor The {@link InstanceDescriptor} to be
		 *        stored by the {@link InstanceDescriptor} property.
		 */
		void setInstanceDescriptor( InstanceDescriptor aInstanceDescriptor );
	}

	/**
	 * Provides a {@link InstanceDescriptor} property.
	 */
	public interface InstanceDescriptorProperty extends InstanceDescriptorAccessor, InstanceDescriptorMutator {}
}
