// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import java.io.Serializable;

import org.refcodes.runtime.RuntimeUtility;

/**
 * The most common information to be provided when describing a proxy residing
 * in a {@link RemoteClient} and which is linked to a {@link RemoteServer}.
 */
class ProxyDescriptorImpl implements ProxyDescriptor, Serializable {

	private static final long serialVersionUID = 1L;

	private Class<?> _type;

	private String _instanceId;

	private Object _proxy;

	/**
	 * Creates a new ProxyDescriptor object.
	 */
	public ProxyDescriptorImpl() {}

	/**
	 * Creates a new {@link ProxyDescriptor} object.
	 * 
	 * @param aProxy The proxy in question.
	 * 
	 * @param aType The type of the proxy in question.
	 * 
	 * @param aInstanceId The instance ID assigned to the proxy in question.
	 */
	public ProxyDescriptorImpl( Object aProxy, Class<?> aType, String aInstanceId ) {
		_proxy = aProxy;
		_type = aType;
		_instanceId = aInstanceId;
	}

	/**
	 * Creates a new {@link ProxyDescriptor} object.
	 * 
	 * @param aClassDescriptor The descriptor describing the class of the proxy
	 *        in question.
	 * 
	 * @param aProxy The proxy in question.
	 */
	public ProxyDescriptorImpl( InstanceDescriptor aClassDescriptor, Object aProxy ) {
		_type = aClassDescriptor.getType();
		_instanceId = aClassDescriptor.getInstanceId();
		_proxy = aProxy;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getInstanceId() {
		return _instanceId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Class<?> getType() {
		return _type;
	}

	/**
	 * Gets the proxy.
	 *
	 * @param <P> the generic type
	 * @return the proxy
	 */
	@SuppressWarnings("unchecked")
	@Override
	public <P> P getProxy() {
		return (P) _proxy;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return RuntimeUtility.toString( "Instance ID = <" + _instanceId + ">; proxy = " + _proxy.toString(), super.toString() );
	}
}
