// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import java.io.Serializable;

/**
 * The Class PublishSubjectMessageImpl.
 */
class PublishSubjectMessageImpl extends ClassDescriptorImpl implements PublishSubjectMessage, Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * {@inheritDoc}.
	 */
	public PublishSubjectMessageImpl() {
		super();
	}

	/**
	 * Creates a new {@link PublishSubjectMessage} instance.
	 * 
	 * @param aClassDescriptor The {@link InstanceDescriptor} describing the
	 *        subject.
	 */
	public PublishSubjectMessageImpl( InstanceDescriptor aClassDescriptor ) {
		this( aClassDescriptor.getType(), aClassDescriptor.getInstanceId() );
	}

	/**
	 * Instantiates a new publish subject message impl.
	 *
	 * @param aType the type
	 * @param aInstanceId the instance id
	 */
	public PublishSubjectMessageImpl( Class<?> aType, String aInstanceId ) {
		super( aType, aInstanceId );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void reset() {
		super.clear();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setClass( Class<?> type ) {
		super.setClass( type );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setClassDescriptor( InstanceDescriptor classDescriptor ) {
		super.setClassDescriptor( classDescriptor );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setInstanceId( String instanceId ) {
		super.setInstanceId( instanceId );
	}
}
