// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.remoting;

import java.io.Serializable;

/**
 * The Class SubjectInstanceDescriptorImpl.
 */
class SubjectInstanceDescriptorImpl extends SubjectDescriptorImpl implements SubjectInstance, Serializable {

	private static final long serialVersionUID = 1L;

	private String _instanceId;

	/**
	 * Creates a new {@link SubjectInstance} instance.
	 * 
	 * @param aSubject The subject in question.
	 * 
	 * @param aInstanceId The instance ID for the subject. available
	 */
	public SubjectInstanceDescriptorImpl( Object aSubject, String aInstanceId ) {
		super( aSubject );
		_instanceId = aInstanceId;
	}

	/**
	 * Creates a new {@link SubjectInstance} instance.
	 * 
	 * @param aSubjectDescriptor The {@link SubjectDescriptor} describing the
	 *        subject.
	 * 
	 * @param aInstanceId The instance ID for the subject. available
	 */
	public SubjectInstanceDescriptorImpl( SubjectDescriptor aSubjectDescriptor, String aInstanceId ) {
		super( aSubjectDescriptor.getSubject() );
		_instanceId = aInstanceId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getInstanceId() {

		return _instanceId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		String out = super.toString() + "\n" + "instance id = " + _instanceId + "\n";

		return out;
	}
}
