/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.DigestException;
import org.refcodes.component.Resetable;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.LoopExtensionTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.io.DatagramTransceiver;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.Disposable;
import org.refcodes.remoting.CloseConnectionMessage;
import org.refcodes.remoting.CloseConnectionMessageImpl;
import org.refcodes.remoting.Message;
import org.refcodes.remoting.Remote;
import org.refcodes.remoting.SignOffProxyMessage;

abstract class AbstractRemote
extends AbstractConnectableAutomaton
implements Remote {
    static final String STATIC_INSTANCE_ID = "static_instance";
    static final String STATIC_SESSION_ID = "static_session";
    static final int INSTANCE_ID_LENGTH = 16;
    static final int SESSION_ID_LENGTH = 32;
    static final long WAIT_FOR_REPLY_TIMEOUT = 30000L;
    static final long WAIT_FOR_ACTIVE_SESSIONS_TIMEOUT_IN_MS = 20000L;
    static final int WAIT_FOR_ACTIVE_SESSIONS_LOOPS = 250;
    static final int WAIT_FOR_REPLY_LOOPS = 250;
    static final boolean PERFORM_CONSISTENCY_CHECKS = false;
    static final boolean ENABLE_EXTENDED_DEBUG_LOGGING = true;
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    DatagramTransceiver<Serializable> _transceiver;
    JobReceiverDaemon _jobReceiverDaemon = null;
    private ExecutorService _executorService;
    private boolean _isDestroyed = false;

    public AbstractRemote() {
        this(null);
    }

    public AbstractRemote(ExecutorService aExecutorService) {
        this._executorService = aExecutorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)aExecutorService);
    }

    public boolean isOpenable(DatagramTransceiver<Serializable> aConnection) {
        return super.isOpenable() && aConnection.isOpened();
    }

    public synchronized void open(DatagramTransceiver<Serializable> aTransceiver) throws IOException {
        this._transceiver = aTransceiver;
        ControlFlowUtility.throwIllegalStateException((this._isDestroyed || this.isOpened() ? 1 : 0) != 0);
        ConnectionStatus theConnectionStatus = this._transceiver.getConnectionStatus();
        if (theConnectionStatus != ConnectionStatus.OPENED) {
            throw new IOException("Unable to open the remote of type <" + this.getClass().getName() + "> as the underlying transcivier of type <" + this._transceiver.getClass().getName() + "> is in status " + theConnectionStatus + " (not open; please open it beofrehand).");
        }
        this._jobReceiverDaemon = new JobReceiverDaemon();
        LOGGER.debug("Starting job receiver daemon <" + this._jobReceiverDaemon.getClass().getName() + ">.");
        this._executorService.execute(this._jobReceiverDaemon);
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDestroyed);
        LOGGER.debug("CLOSE called on <" + this.getClass().getName() + ">.");
        super.close();
        this._jobReceiverDaemon.dispose();
        this._jobReceiverDaemon = null;
        if (this._transceiver.isOpened()) {
            this._transceiver.close();
        }
    }

    public void destroy() {
        if (!this._isDestroyed) {
            try {
                try {
                    this.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Destroying failed as of: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    this._executorService.shutdownNow();
                    try {
                        try {
                            this._transceiver.close();
                        }
                        catch (IOException e2) {
                            LOGGER.warn("Destroying failed as of: " + ExceptionUtility.toMessage((Throwable)e2), (Throwable)e2);
                            this._isDestroyed = true;
                        }
                    }
                    finally {
                        this._isDestroyed = true;
                    }
                }
            }
            finally {
                block21: {
                    this._executorService.shutdownNow();
                    try {
                        try {
                            this._transceiver.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("Destroying failed as of: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                            this._isDestroyed = true;
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        this._isDestroyed = true;
                        throw throwable;
                    }
                    this._isDestroyed = true;
                }
            }
        }
    }

    protected abstract void digest(Message var1) throws DigestException;

    protected void toReceiver(Message aJob) throws IOException {
        block2: {
            try {
                this._transceiver.transmit((Serializable)aJob);
            }
            catch (IOException aException) {
                if (aJob instanceof CloseConnectionMessage) break block2;
                throw aException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fromSender(Message aJob) {
        ControlFlowUtility.throwIllegalStateException((boolean)this._isDestroyed);
        if (this.isOpened()) {
            if (aJob instanceof CloseConnectionMessage) {
                LOGGER.debug("Received a close connection job to <" + this.getClass().getName() + ">; closing connection.");
                AbstractRemote abstractRemote = this;
                synchronized (abstractRemote) {
                    if (this.isOpened()) {
                        this.close((CloseConnectionMessage)aJob);
                    }
                }
            } else {
                JobDigesterDaemonImpl theJobDigesterDaemon = new JobDigesterDaemonImpl(aJob);
                this._executorService.execute(theJobDigesterDaemon);
            }
        } else {
            if (!(aJob instanceof CloseConnectionMessage)) {
                throw new IllegalStateException("Received a job <" + aJob + "> though this remote \"" + this.getClass().getName() + "\" is not in opened status; connection status is " + this.getConnectionStatus());
            }
            LOGGER.info("Ignoring job of type \"" + aJob.getClass().getName() + "\" being received whilst connection has been closed.");
        }
    }

    protected ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected synchronized void close(CloseConnectionMessage aJob) {
        if (aJob == null) {
            try {
                this.toReceiver(new CloseConnectionMessageImpl());
            }
            catch (IOException aMessage) {
                LOGGER.warn("Sending a close connection job to the communication couinterpart caused an exception.", (Throwable)aMessage);
            }
        }
    }

    protected boolean isDestroyed() {
        return this._isDestroyed;
    }

    protected void onOpened() {
    }

    protected void onClosed() {
    }

    protected class JobDigesterDaemonImpl
    implements Runnable,
    Resetable {
        private Message _job = null;

        public JobDigesterDaemonImpl(Message aJob) {
            this._job = aJob;
        }

        public void reset() {
            this._job = null;
        }

        @Override
        public void run() {
            block2: {
                try {
                    AbstractRemote.this.digest(this._job);
                }
                catch (DigestException aException) {
                    if (this._job instanceof SignOffProxyMessage && !AbstractRemote.this.isOpened()) break block2;
                    LOGGER.warn("Unable to digest the job \"" + this._job.getClass().getName() + "\" as of a digest exception: \"" + ExceptionUtility.toMessage((Throwable)aException) + "\"", (Throwable)aException);
                }
            }
        }
    }

    protected class JobReceiverDaemon
    implements Runnable,
    Disposable.Disposedable {
        private boolean _isDisposed = false;

        protected JobReceiverDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    while (!this._isDisposed && this.isOpened()) {
                        LOGGER.debug("Waiting for Datagram ...");
                        Message eJob = (Message)AbstractRemote.this._transceiver.receive();
                        LOGGER.debug("Read datagram <" + eJob + ">.");
                        if (AbstractRemote.this.isOpened()) {
                            AbstractRemote.this.fromSender(eJob);
                            continue;
                        }
                        LOGGER.info("Ignoring job of type \"" + eJob.getClass().getName() + "\" being received whilst connection has been closed.");
                    }
                }
                catch (IOException aException) {
                    boolean isTransceiverClosed = AbstractRemote.this._transceiver.isClosed();
                    AbstractRemote abstractRemote = AbstractRemote.this;
                    synchronized (abstractRemote) {
                        if (AbstractRemote.this.isOpened()) {
                            try {
                                AbstractRemote.this.close();
                            }
                            catch (IOException e) {
                                LOGGER.warn("Unable to close the malfunctioning connection: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                            }
                        }
                    }
                    if (isTransceiverClosed) break block10;
                    LOGGER.warn("Caught an exception in daemon while reading jobs from the transceiver (receiver); the connection status is " + AbstractRemote.this.getConnectionStatus() + " (will get closed if not already); the transceiver's connection status is " + AbstractRemote.this.getConnectionStatus() + ": " + ExceptionUtility.toMessage((Throwable)aException), (Throwable)aException);
                    throw new HiddenException((Throwable)aException);
                }
            }
        }

        private boolean isOpened() {
            if (!AbstractRemote.this.isOpened()) {
                return false;
            }
            if (AbstractRemote.this._transceiver.isOpened() && AbstractRemote.this.isOpened()) {
                return true;
            }
            if (AbstractRemote.this.isOpened() && !AbstractRemote.this._transceiver.isOpened()) {
                RetryCounter theRetryCounter = new RetryCounter(IoRetryCount.NORM.getValue().intValue(), (long)LatencySleepTime.NORM.getTimeInMs(), (long)LoopExtensionTime.NORM.getTimeInMs());
                while (AbstractRemote.this.isOpened() && theRetryCounter.hasNextRetry() && !AbstractRemote.this._transceiver.isOpened()) {
                    LOGGER.debug("Wait loop <" + theRetryCounter.getRetryCount() + "> while waiting for OPEN for <" + 250 + "> ms; connection status is " + AbstractRemote.this.getConnectionStatus() + " (transceiver connection status is " + AbstractRemote.this._transceiver.getConnectionStatus() + ").");
                    theRetryCounter.nextRetry();
                }
            }
            return AbstractRemote.this._transceiver.isOpened() && AbstractRemote.this.isOpened();
        }

        public void dispose() {
            this._isDisposed = true;
        }

        public boolean isDisposed() {
            return this._isDisposed;
        }
    }
}

