/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.refcodes.remoting.MethodRequest;
import org.refcodes.remoting.SerializeUtility;

class MethodRequestDescriptorImpl
implements MethodRequest,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] _argumentArray;
    private String _instanceId;
    private String _methodName;
    private Class<?>[] _parameterTypes;
    private String _sessionId;

    public MethodRequestDescriptorImpl() {
    }

    public MethodRequestDescriptorImpl(MethodRequest aMethodRequestDescriptor) {
        this._instanceId = aMethodRequestDescriptor.getInstanceId();
        this._sessionId = aMethodRequestDescriptor.getSessionId();
        this._argumentArray = aMethodRequestDescriptor.getArgumentArray();
        this._methodName = aMethodRequestDescriptor.getMethodName();
        this._parameterTypes = aMethodRequestDescriptor.getArgumentTypeArray();
    }

    public MethodRequestDescriptorImpl(Method aMethod, Object[] aArguments, String aInstanceId, String aSessionId) {
        this._instanceId = aInstanceId;
        this._sessionId = aSessionId;
        this._argumentArray = aArguments;
        this._methodName = aMethod.getName();
        this._parameterTypes = aMethod.getParameterTypes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Method) {
            Method method = (Method)obj;
            if (!this._methodName.equals(method.getName())) {
                return false;
            }
            if (this._parameterTypes.length != method.getParameterTypes().length) {
                return false;
            }
            int theLength = this._parameterTypes.length;
            int i = 0;
            while (i < theLength) {
                boolean isMatch = false;
                int l = 0;
                while (l < theLength) {
                    if (this._parameterTypes[i].equals(method.getParameterTypes()[l])) {
                        isMatch = true;
                        break;
                    }
                    ++l;
                }
                if (!isMatch) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof MethodRequest) {
            MethodRequest method = (MethodRequest)obj;
            if (!this._methodName.equals(method.getMethodName())) {
                return false;
            }
            if (this._parameterTypes.length != method.getArgumentTypeArray().length) {
                return false;
            }
            int theLength = this._parameterTypes.length;
            int i = 0;
            while (i < theLength) {
                boolean isMatch = false;
                int l = 0;
                while (l < theLength) {
                    if (this._parameterTypes[i].equals(method.getArgumentTypeArray()[l])) {
                        isMatch = true;
                        break;
                    }
                    ++l;
                }
                if (!isMatch) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public Object[] getArgumentArray() {
        return this._argumentArray;
    }

    @Override
    public Class<?>[] getArgumentTypeArray() {
        return this._parameterTypes;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    @Override
    public String getMethodName() {
        return this._methodName;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    public String toString() {
        String out = String.valueOf(super.toString()) + "\n" + "instance id = " + this._instanceId + "\n" + "session id = " + this._sessionId + "\n" + "name = " + this._methodName + "\n";
        if (this._argumentArray != null) {
            int i = 0;
            while (i < this._argumentArray.length) {
                out = String.valueOf(out) + "arguments[" + i + "] = " + this._argumentArray[i] + "\n";
                ++i;
            }
        }
        return out;
    }

    protected void setArgumentArray(Object[] arguments) {
        this._argumentArray = arguments;
        if (this._argumentArray != null) {
            int i = 0;
            while (i < this._argumentArray.length) {
                this._argumentArray[i] = SerializeUtility.toSerializable(this._argumentArray[i]);
                ++i;
            }
        }
    }

    protected void setInstanceId(String instanceId) {
        this._instanceId = instanceId;
    }

    protected void setMethodName(String aMethodName) {
        this._methodName = aMethodName;
    }

    protected void setMethodRequestDescriptor(MethodRequest methodRequestDescriptor) {
        this._instanceId = methodRequestDescriptor.getInstanceId();
        this._methodName = methodRequestDescriptor.getMethodName();
        this._argumentArray = methodRequestDescriptor.getArgumentArray();
        this._parameterTypes = methodRequestDescriptor.getArgumentTypeArray();
        this._sessionId = methodRequestDescriptor.getSessionId();
    }

    protected void setParameterTypes(Class<?>[] parameterTypes) {
        this._parameterTypes = parameterTypes;
    }

    protected void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    protected void clear() {
        this._instanceId = null;
        this._parameterTypes = null;
        this._sessionId = null;
        this._argumentArray = null;
        this._methodName = null;
    }
}

