/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.refcodes.remoting.MethodRequest;
import org.refcodes.remoting.SerializeUtility;

class MethodRequestDescriptorImpl
implements MethodRequest,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] _argumentArray;
    private String _instanceId;
    private String _methodName;
    private Class<?>[] _parameterTypes;
    private String _sessionId;

    public MethodRequestDescriptorImpl() {
    }

    public MethodRequestDescriptorImpl(MethodRequest aMethodRequestDescriptor) {
        this._instanceId = aMethodRequestDescriptor.getInstanceId();
        this._sessionId = aMethodRequestDescriptor.getSessionId();
        this._argumentArray = aMethodRequestDescriptor.getArgumentArray();
        this._methodName = aMethodRequestDescriptor.getMethodName();
        this._parameterTypes = aMethodRequestDescriptor.getArgumentTypeArray();
    }

    public MethodRequestDescriptorImpl(Method aMethod, Object[] aArguments, String aInstanceId, String aSessionId) {
        this._instanceId = aInstanceId;
        this._sessionId = aSessionId;
        this._argumentArray = aArguments;
        this._methodName = aMethod.getName();
        this._parameterTypes = aMethod.getParameterTypes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Method) {
            Method method = (Method)obj;
            if (!this._methodName.equals(method.getName())) {
                return false;
            }
            if (this._parameterTypes.length != method.getParameterTypes().length) {
                return false;
            }
            int theLength = this._parameterTypes.length;
            for (int i = 0; i < theLength; ++i) {
                boolean isMatch = false;
                for (int l = 0; l < theLength; ++l) {
                    if (!this._parameterTypes[i].equals(method.getParameterTypes()[l])) continue;
                    isMatch = true;
                    break;
                }
                if (isMatch) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof MethodRequest) {
            MethodRequest method = (MethodRequest)obj;
            if (!this._methodName.equals(method.getMethodName())) {
                return false;
            }
            if (this._parameterTypes.length != method.getArgumentTypeArray().length) {
                return false;
            }
            int theLength = this._parameterTypes.length;
            for (int i = 0; i < theLength; ++i) {
                boolean isMatch = false;
                for (int l = 0; l < theLength; ++l) {
                    if (!this._parameterTypes[i].equals(method.getArgumentTypeArray()[l])) continue;
                    isMatch = true;
                    break;
                }
                if (isMatch) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Object[] getArgumentArray() {
        return this._argumentArray;
    }

    @Override
    public Class<?>[] getArgumentTypeArray() {
        return this._parameterTypes;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    @Override
    public String getMethodName() {
        return this._methodName;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    public String toString() {
        String out = super.toString() + "\ninstance id = " + this._instanceId + "\nsession id = " + this._sessionId + "\nname = " + this._methodName + "\n";
        if (this._argumentArray != null) {
            for (int i = 0; i < this._argumentArray.length; ++i) {
                out = out + "arguments[" + i + "] = " + this._argumentArray[i] + "\n";
            }
        }
        return out;
    }

    protected void setArgumentArray(Object[] arguments) {
        this._argumentArray = arguments;
        if (this._argumentArray != null) {
            for (int i = 0; i < this._argumentArray.length; ++i) {
                this._argumentArray[i] = SerializeUtility.toSerializable(this._argumentArray[i]);
            }
        }
    }

    protected void setInstanceId(String instanceId) {
        this._instanceId = instanceId;
    }

    protected void setMethodName(String aMethodName) {
        this._methodName = aMethodName;
    }

    protected void setMethodRequestDescriptor(MethodRequest methodRequestDescriptor) {
        this._instanceId = methodRequestDescriptor.getInstanceId();
        this._methodName = methodRequestDescriptor.getMethodName();
        this._argumentArray = methodRequestDescriptor.getArgumentArray();
        this._parameterTypes = methodRequestDescriptor.getArgumentTypeArray();
        this._sessionId = methodRequestDescriptor.getSessionId();
    }

    protected void setParameterTypes(Class<?>[] parameterTypes) {
        this._parameterTypes = parameterTypes;
    }

    protected void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    protected void clear() {
        this._instanceId = null;
        this._parameterTypes = null;
        this._sessionId = null;
        this._argumentArray = null;
        this._methodName = null;
    }
}

