/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.DigestException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeout;
import org.refcodes.data.IoTimeout;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.generator.Generator;
import org.refcodes.generator.UniqueIdGenerator;
import org.refcodes.mixin.BusyAccessor;
import org.refcodes.remoting.AbstractRemote;
import org.refcodes.remoting.CancelMethodReplyMessage;
import org.refcodes.remoting.ClassDescriptor;
import org.refcodes.remoting.CloseConnectionMessage;
import org.refcodes.remoting.DuplicateInstanceIdRuntimeException;
import org.refcodes.remoting.InstanceDescriptor;
import org.refcodes.remoting.InstanceId;
import org.refcodes.remoting.InvalidMethodReplyRuntimeException;
import org.refcodes.remoting.InvalidMethodRequestRuntimeException;
import org.refcodes.remoting.Message;
import org.refcodes.remoting.MethodReplyMessage;
import org.refcodes.remoting.MethodRequest;
import org.refcodes.remoting.MethodRequestMessage;
import org.refcodes.remoting.PublishSubjectMessage;
import org.refcodes.remoting.PublishSubjectReplyMessage;
import org.refcodes.remoting.Remote;
import org.refcodes.remoting.Reply;
import org.refcodes.remoting.ReplyDescriptor;
import org.refcodes.remoting.SerializeUtility;
import org.refcodes.remoting.SignOffProxyMessage;
import org.refcodes.remoting.SignOffSubjectMessage;
import org.refcodes.remoting.SubjectDescriptor;
import org.refcodes.remoting.SubjectInstanceDescriptor;
import org.refcodes.remoting.UnknownInstanceIdRuntimeException;

public class RemoteServer
extends AbstractRemote
implements Remote {
    private static Logger LOGGER = Logger.getLogger(RemoteServer.class.getName());
    private InstanceHandler _instanceHandler = new InstanceHandler();
    private Generator<String> _instanceIdGenerator = new UniqueIdGenerator(16);

    public RemoteServer() {
        super(null);
    }

    public RemoteServer(ExecutorService aExecutorService) {
        super(aExecutorService);
    }

    public void clear() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        this.signOffAllSubjects();
    }

    @Override
    public synchronized void close() throws IOException {
        LOGGER.info("CLOSE called on <" + this.getClass().getName() + ">.");
        this.close(null);
    }

    public boolean isBusy() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.isBusy();
    }

    public boolean hasSubject(Object aSubject) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.hasSubject(aSubject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Object> subjects() {
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            ArrayList<Object> thjeList = new ArrayList<Object>(this._instanceHandler.getSubjects());
            return thjeList.iterator();
        }
    }

    public boolean isEmpty() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean publishSubject(Object aSubject) throws IOException {
        ControlFlowUtility.throwIllegalStateException((this.isDestroyed() && !this.isOpened() ? 1 : 0) != 0);
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            String theInstanceId;
            block19: {
                SubjectDescriptor eObjDescriptor;
                Iterator<SubjectDescriptor> e = this._instanceHandler.subjectDescriptors();
                do {
                    if (e.hasNext()) continue;
                    if (this._instanceHandler.hasSubject(aSubject)) {
                        return false;
                    }
                    theInstanceId = null;
                    Generator<String> generator = this._instanceIdGenerator;
                    synchronized (generator) {
                        if (!this._instanceIdGenerator.hasNext()) {
                            throw new IllegalStateException("The instance TID generator in use is unable to produce more instance IDs.");
                        }
                        theInstanceId = (String)this._instanceIdGenerator.next();
                        break block19;
                    }
                } while ((eObjDescriptor = e.next()).getSubject() != aSubject);
                return false;
            }
            if (this._instanceHandler.hasInstanceId(theInstanceId)) {
                throw new DuplicateInstanceIdRuntimeException("The instance TID generator in use produces duplicate instance IDs.");
            }
            SubjectInstanceDescriptor theSubjectInstanceDescriptor = new SubjectInstanceDescriptor(aSubject, theInstanceId);
            ClassDescriptor classDescriptor = new ClassDescriptor(aSubject.getClass(), theInstanceId);
            if (this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
                throw new DuplicateInstanceIdRuntimeException("The instance TID <" + theInstanceId + "> is already in use by the internal instance handler.");
            }
            PublishSubjectMessage thePublishSubjectJob = new PublishSubjectMessage();
            thePublishSubjectJob.setClassDescriptor(classDescriptor);
            PublishSubjectReplyMessage theMethodReplyRemotingJob = new PublishSubjectReplyMessage();
            theMethodReplyRemotingJob.setInstanceId(theInstanceId);
            theMethodReplyRemotingJob.setHasReply(false);
            this._instanceHandler.addReplyDescriptor(theMethodReplyRemotingJob, theInstanceId);
            try {
                this.toReceiver(thePublishSubjectJob);
            }
            catch (IOException aException) {
                LOGGER.log(Level.WARNING, ExceptionUtility.toMessage((Throwable)aException), aException);
                this._instanceHandler.removeReplyDescriptor(theInstanceId);
                if (aException.getCause() instanceof IOException) {
                    this.closeOnException();
                }
                throw aException;
            }
            RetryTimeout theRetryTimeout = new RetryTimeout(30000L, 250);
            while (true) {
                if (theMethodReplyRemotingJob.hasReply() || !theRetryTimeout.hasNextRetry() || !this.isOpened()) {
                    this._instanceHandler.removeReplyDescriptor(theInstanceId);
                    if (theMethodReplyRemotingJob.hasReply()) break;
                    throw new IllegalStateException("While processing the request a timeout of 30000 ms has been overshot; propably lost the connection (you propably should close the connection).");
                }
                LOGGER.info("Wait loop <" + theRetryTimeout.getRetryCount() + "> while waiting for method reply for <" + 250 + "> ms.");
                theRetryTimeout.nextRetry((Object)theMethodReplyRemotingJob);
            }
            if (theMethodReplyRemotingJob.isException()) {
                throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a class descripter. Sorry - operation aborted!");
            }
            if (theMethodReplyRemotingJob.isReturnValue() && theMethodReplyRemotingJob.getReturnValue() instanceof Boolean) {
                boolean theReturnValue = (Boolean)theMethodReplyRemotingJob.getReturnValue();
                if (theReturnValue) {
                    this._instanceHandler.addSubjectDescriptor(theSubjectInstanceDescriptor, theInstanceId);
                    this.onSubjectPublished(theSubjectInstanceDescriptor.getSubject());
                }
                return theReturnValue;
            }
            throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a class descripter. Sorry - operation aborted!");
        }
    }

    public boolean signOffSubject(Object aSubject) throws IOException, VetoException {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        String theSubjectId = this.toSubjectId(aSubject);
        if (theSubjectId == null) {
            return false;
        }
        return this.signoffInstanceDescriptor(new InstanceDescriptor(theSubjectId), -1);
    }

    public boolean signOffSubject(Object aSubject, int aTimeoutMillis) throws IOException {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        String theSubjectId = this.toSubjectId(aSubject);
        if (theSubjectId == null) {
            return false;
        }
        try {
            return this.signoffInstanceDescriptor(new InstanceDescriptor(theSubjectId), aTimeoutMillis);
        }
        catch (VetoException aException) {
            throw new VetoException.VetoRuntimeException(aException.getMessage(), (Throwable)aException);
        }
    }

    public int size() {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        return this._instanceHandler.size();
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyed()) {
            super.destroy();
            this._instanceHandler.clear();
            this._instanceHandler = null;
            this._instanceIdGenerator = null;
        }
    }

    protected void doSendJob(Message aJob) throws IOException {
        this.toReceiver(aJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(Message aJob) throws DigestException {
        block17: {
            try {
                if (aJob == null) {
                    return;
                }
                if (aJob instanceof CloseConnectionMessage) {
                    LOGGER.info("Received a close connection job to <" + this.getClass().getName() + ">; closing connection.");
                    this.close((CloseConnectionMessage)aJob);
                    break block17;
                }
                if (aJob instanceof PublishSubjectReplyMessage) {
                    PublishSubjectReplyMessage theReplyRemotingJob = (PublishSubjectReplyMessage)aJob;
                    if (theReplyRemotingJob.getInstanceId() == null) {
                        return;
                    }
                    String theInstanceId = theReplyRemotingJob.getInstanceId();
                    if (!this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
                        throw new UnknownInstanceIdRuntimeException("Expected an instance TID <" + theInstanceId + "> which was not found in order to reply to a request...");
                    }
                    Reply tmpReply = this._instanceHandler.getMethodReplyDescriptor(theInstanceId);
                    if (!(tmpReply instanceof PublishSubjectReplyMessage)) {
                        throw new InvalidMethodReplyRuntimeException("Excpected a <" + PublishSubjectReplyMessage.class.toString() + "> to put the reply in.");
                    }
                    PublishSubjectReplyMessage thePublishSubjectReplyJob = (PublishSubjectReplyMessage)tmpReply;
                    thePublishSubjectReplyJob.setReply(theReplyRemotingJob);
                    PublishSubjectReplyMessage publishSubjectReplyMessage = thePublishSubjectReplyJob;
                    synchronized (publishSubjectReplyMessage) {
                        thePublishSubjectReplyJob.notifyAll();
                        break block17;
                    }
                }
                if (aJob instanceof MethodRequestMessage) {
                    MethodRequest theMethodRequestDescriptor = (MethodRequest)((Object)aJob);
                    Reply theMethodReplyDescriptor = this.pushMethodRequest(theMethodRequestDescriptor);
                    if (theMethodReplyDescriptor == null) {
                        return;
                    }
                    MethodReplyMessage theMethodReplyJob = new MethodReplyMessage();
                    theMethodReplyJob.setMethodReplyDescriptor(theMethodReplyDescriptor);
                    this.toReceiver(theMethodReplyJob);
                } else if (aJob instanceof SignOffProxyMessage) {
                    Message instanceDescriptor = aJob;
                    boolean theReturnValue = this.serviceSignoffInstanceDescriptor(instanceDescriptor);
                    CancelMethodReplyMessage theCancelReplyRemotingJob = new CancelMethodReplyMessage();
                    theCancelReplyRemotingJob.setInstanceId(instanceDescriptor.getInstanceId());
                    theCancelReplyRemotingJob.setException(null);
                    theCancelReplyRemotingJob.setReturnValue(theReturnValue);
                    theCancelReplyRemotingJob.setHasReply(true);
                    try {
                        this.toReceiver(theCancelReplyRemotingJob);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException aException) {
                throw new DigestException((Throwable)aException);
            }
        }
    }

    @Override
    protected synchronized void close(CloseConnectionMessage aJob) {
        ControlFlowUtility.throwIllegalStateException((boolean)this.isDestroyed());
        LOGGER.info("CLOSE called on <" + this.getClass().getName() + "> with job <" + aJob + ">.");
        if (!this.isClosed()) {
            super.close(aJob);
            RetryTimeout theRetryTimeout = new RetryTimeout((long)IoTimeout.NORM.getTimeMillis(), RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue().intValue());
            while (this.isBusy() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
                LOGGER.info("Wait loop <" + theRetryTimeout.getRetryCount() + "> while being BUSY for <" + SleepLoopTime.NORM.getTimeMillis() + "> ms.");
                theRetryTimeout.nextRetry();
            }
            if (this.isBusy()) {
                LOGGER.log(Level.WARNING, "Still being BUSY even after reaching the timeout of <" + IoTimeout.NORM.getTimeMillis() + "> ms, closing connection nonetheless.");
            }
            this.signOffAllSubjects();
            try {
                super.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to close malfunctioning connection.", e);
            }
            this.onClosed();
        }
    }

    protected void onSubjectPublished(Object aSubject) {
    }

    protected void onSubjectSignedOff(Object aSubject) {
    }

    private boolean signOffSubject(SubjectDescriptor aSubject) throws IOException {
        boolean theResult;
        if (this.isClosed()) {
            return false;
        }
        String eId = null;
        Iterator<String> e = this._instanceHandler.instanceIds();
        while (e.hasNext()) {
            eId = e.next();
            if (this._instanceHandler.getSubjectDescriptor(eId) == aSubject) break;
        }
        if (eId == null) {
            return false;
        }
        try {
            theResult = this.signoffInstanceDescriptor(new InstanceDescriptor(eId), 0);
        }
        catch (VetoException ve) {
            theResult = true;
        }
        return theResult;
    }

    private String toSubjectId(Object aSubject) {
        String eId = null;
        boolean returnValue = false;
        Iterator<Object> e = this.subjects();
        while (e.hasNext()) {
            Object eObj = e.next();
            if (eObj != aSubject) continue;
            returnValue = true;
        }
        if (!returnValue) {
            return null;
        }
        Iterator<Object> ee = this.subjects();
        while (ee.hasNext()) {
            Object eObj = ee.next();
            if (!(eObj instanceof SubjectInstanceDescriptor) || ((SubjectInstanceDescriptor)eObj).getSubject() != aSubject) continue;
            eId = ((SubjectInstanceDescriptor)eObj).getInstanceId();
        }
        return eId;
    }

    private void clearOnException() {
        Iterator<SubjectDescriptor> e = this._instanceHandler.subjectDescriptors();
        while (e.hasNext()) {
            SubjectDescriptor eObjectDescriptor = e.next();
            this.onSubjectSignedOff(eObjectDescriptor.getSubject());
        }
        this._instanceHandler.clear();
    }

    private void signOffAllSubjects() {
        Iterator<SubjectDescriptor> e = this._instanceHandler.subjectDescriptors();
        while (e.hasNext()) {
            try {
                SubjectDescriptor eObjDescriptor = e.next();
                this.signOffSubject(eObjDescriptor);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, "Catched a <ConnectionUnpredictableException> with message = " + ioe.getMessage());
                if (!(ioe.getCause() instanceof IOException)) continue;
                this.clearOnException();
            }
        }
        this._instanceHandler.clear();
    }

    private void closeOnException() {
        this.clearOnException();
        Iterator<SubjectDescriptor> e = this._instanceHandler.subjectDescriptors();
        while (e.hasNext()) {
            SubjectDescriptor eObjectDescriptor = e.next();
            this.onSubjectSignedOff(eObjectDescriptor.getSubject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reply pushMethodRequest(MethodRequest aMethodRequestDescriptor) throws IOException {
        SubjectDescriptor objDescriptor;
        if (aMethodRequestDescriptor == null) {
            return null;
        }
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            objDescriptor = this._instanceHandler.getSubjectDescriptor(aMethodRequestDescriptor.getInstanceId());
        }
        if (objDescriptor == null) {
            return null;
        }
        try {
            MethodInvokationDaemon theDaemon = new MethodInvokationDaemon(objDescriptor.getSubject(), aMethodRequestDescriptor.getMethodName(), aMethodRequestDescriptor.getArgumentArray(), aMethodRequestDescriptor.getArgumentTypeArray());
            this.getExecutorService().execute(theDaemon);
            RetryTimeout theRetryTimeout = new RetryTimeout(24000L, 250);
            while (!theDaemon.hasResult() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
                theRetryTimeout.nextRetry((Object)theDaemon);
            }
            if (!theDaemon.hasResult()) {
                LOGGER.log(Level.WARNING, "Some timeout has occurred - timeout is ignored...");
            }
            ReplyDescriptor theMethodReplyDescriptor = new ReplyDescriptor(theDaemon.getReturnValue(), theDaemon.getException(), aMethodRequestDescriptor);
            return theMethodReplyDescriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidMethodRequestRuntimeException(iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidMethodRequestRuntimeException(nsme);
        }
    }

    private boolean serviceSignoffInstanceDescriptor(InstanceId aInstanceDescriptor) {
        if (aInstanceDescriptor == null) {
            throw new NullPointerException("Expected an object of type <GenericInstanceDescriptor> instead of a null value in argument <instanceDescriptor>.");
        }
        if (aInstanceDescriptor.getInstanceId() == null) {
            throw new NullPointerException("Expected an object of type <String> instead of a null value when retrieving the instance id of argument <instanceDescriptor>.");
        }
        String instanceId = aInstanceDescriptor.getInstanceId();
        if (this._instanceHandler.hasSignedOffInstanceId(instanceId)) {
            return true;
        }
        SubjectDescriptor theSubjectDescriptor = this._instanceHandler.getSubjectDescriptor(instanceId);
        if (theSubjectDescriptor == null) {
            RetryTimeout theRetryTimeout = new RetryTimeout((long)IoTimeout.MIN.getTimeMillis(), RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue().intValue());
            while (!this.isClosed() && theRetryTimeout.hasNextRetry() && theSubjectDescriptor == null) {
                theRetryTimeout.nextRetry();
                theSubjectDescriptor = this._instanceHandler.getSubjectDescriptor(instanceId);
            }
            if (theSubjectDescriptor == null && !this.isClosed()) {
                LOGGER.log(Level.WARNING, "Expected known instance TID, but instance TID  <" + instanceId + "> is not known by the server (probably all instances have been signed off).");
            }
        }
        if (theSubjectDescriptor != null) {
            this.onSubjectSignedOff(theSubjectDescriptor.getSubject());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean signoffInstanceDescriptor(InstanceId aInstanceDescriptor, int aTimeoutMillis) throws IOException, VetoException {
        if (aInstanceDescriptor == null) {
            return false;
        }
        if (aInstanceDescriptor.getInstanceId() == null) {
            return false;
        }
        String theInstanceId = aInstanceDescriptor.getInstanceId();
        if (!this._instanceHandler.hasInstanceId(theInstanceId)) {
            return false;
        }
        if (!this._instanceHandler.hasMethodReplyDescriptor(theInstanceId)) {
            return false;
        }
        if (this._instanceHandler.hasSignedOffInstanceId(theInstanceId)) {
            throw new DuplicateInstanceIdRuntimeException("The instance <" + theInstanceId + "> of the provided instance descriptorin is already in use and being used up.");
        }
        SignOffSubjectMessage theSignoffSubjectJob = new SignOffSubjectMessage();
        theSignoffSubjectJob.setInstanceId(aInstanceDescriptor.getInstanceId());
        theSignoffSubjectJob.setReadTimeoutMillis(aTimeoutMillis);
        PublishSubjectReplyMessage thePublishSubjectReplyJob = new PublishSubjectReplyMessage();
        thePublishSubjectReplyJob.setInstanceId(theInstanceId);
        thePublishSubjectReplyJob.setHasReply(false);
        InstanceHandler instanceHandler = this._instanceHandler;
        synchronized (instanceHandler) {
            this._instanceHandler.addReplyDescriptor(thePublishSubjectReplyJob, theInstanceId);
        }
        this.toReceiver(theSignoffSubjectJob);
        RetryTimeout theRetryTimeout = new RetryTimeout(30000L, 250);
        while (!thePublishSubjectReplyJob.hasReply() && theRetryTimeout.hasNextRetry() && this.isOpened()) {
            LOGGER.info("Wait loop <" + theRetryTimeout.getRetryCount() + "> while waiting for method reply for <" + 250 + "> ms.");
            theRetryTimeout.nextRetry((Object)thePublishSubjectReplyJob);
        }
        InstanceHandler instanceHandler2 = this._instanceHandler;
        synchronized (instanceHandler2) {
            this._instanceHandler.removeReplyDescriptor(theInstanceId);
        }
        if (!thePublishSubjectReplyJob.hasReply()) {
            throw new IllegalStateException("While processing the request a timeout of 30000 ms has been overshot; propably lost the connection (you propably should close the connection).");
        }
        if (thePublishSubjectReplyJob.isException()) {
            Throwable theException = thePublishSubjectReplyJob.getException();
            if (theException instanceof VetoException) {
                if (aTimeoutMillis != 0) {
                    if (aTimeoutMillis > 0) {
                        RemoteServer remoteServer = this;
                        synchronized (remoteServer) {
                            try {
                                Thread.sleep(aTimeoutMillis);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (aTimeoutMillis == -1) {
                        throw (VetoException)theException;
                    }
                }
            } else {
                throw new InvalidMethodReplyRuntimeException("Unexpected reply when publishing a subject.");
            }
        }
        if (thePublishSubjectReplyJob.isReturnValue() && thePublishSubjectReplyJob.getReturnValue() instanceof Boolean) {
            SubjectDescriptor theSubjectDescriptor = this._instanceHandler.removeSubjectDescriptor(theInstanceId);
            this.onSubjectSignedOff(theSubjectDescriptor.getSubject());
            return (Boolean)thePublishSubjectReplyJob.getReturnValue();
        }
        return false;
    }

    private static class InstanceHandler
    implements BusyAccessor {
        private Map<String, SubjectDescriptor> _instanceIdsToSubjectDescriptors = new HashMap<String, SubjectDescriptor>();
        private Map<String, Reply> _instanceIdToMethodReplyDescriptor = new HashMap<String, Reply>();
        private List<Object> _subjects = new ArrayList<Object>();
        private Set<String> _signedOffInstanceIds = Collections.newSetFromMap(new WeakHashMap());

        private InstanceHandler() {
        }

        boolean addReplyDescriptor(Reply aMethodReplyDescriptor, String aInstanceId) {
            if (this.hasMethodReplyDescriptor(aInstanceId)) {
                return false;
            }
            if (this.hasSignedOffInstanceId(aInstanceId)) {
                return false;
            }
            this._instanceIdToMethodReplyDescriptor.put(aInstanceId, aMethodReplyDescriptor);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSignedOffInstanceId(String instanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                return this._signedOffInstanceIds.add(instanceId);
            }
        }

        void clear() {
            this.clearSignedOffInstanceIds();
            this.clearSubjectDescriptos();
            this.clearReplyDescriptors();
        }

        List<Object> getSubjects() {
            return this._subjects;
        }

        Reply getMethodReplyDescriptor(String aInstanceId) {
            if (!this.hasMethodReplyDescriptor(aInstanceId)) {
                return null;
            }
            if (this.hasSignedOffInstanceId(aInstanceId)) {
                return null;
            }
            return this._instanceIdToMethodReplyDescriptor.get(aInstanceId);
        }

        boolean hasInstanceId(String instanceId) {
            return this._instanceIdsToSubjectDescriptors.containsKey(instanceId) || this._signedOffInstanceIds.contains(instanceId);
        }

        boolean hasSubject(Object obj) {
            return this._subjects.contains(obj);
        }

        boolean hasMethodReplyDescriptor(String instanceId) {
            return this._instanceIdToMethodReplyDescriptor.containsKey(instanceId);
        }

        boolean hasSignedOffInstanceId(String instanceId) {
            return this._signedOffInstanceIds.contains(instanceId);
        }

        Iterator<String> instanceIds() {
            return this._instanceIdsToSubjectDescriptors.keySet().iterator();
        }

        boolean isEmpty() {
            return this._subjects.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSubjectDescriptor(SubjectDescriptor theObjectDescriptor, String aInstanceId) {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                block6: {
                    block8: {
                        block7: {
                            if (this._instanceIdsToSubjectDescriptors.containsKey(aInstanceId)) break block6;
                            if (!this.hasInstanceId(aInstanceId)) break block7;
                            return false;
                        }
                        if (!this.hasSubject(theObjectDescriptor.getSubject())) break block8;
                        return false;
                    }
                    this._instanceIdsToSubjectDescriptors.put(aInstanceId, theObjectDescriptor);
                    this._subjects.add(theObjectDescriptor.getSubject());
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator<SubjectDescriptor> subjectDescriptors() {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                ArrayList<SubjectDescriptor> returnList = new ArrayList<SubjectDescriptor>(this._instanceIdsToSubjectDescriptors.values());
                return returnList.iterator();
            }
        }

        SubjectDescriptor getSubjectDescriptor(String aInstanceId) {
            return this._instanceIdsToSubjectDescriptors.get(aInstanceId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SubjectDescriptor removeSubjectDescriptor(String aInstanceId) {
            block7: {
                InstanceHandler instanceHandler = this;
                synchronized (instanceHandler) {
                    SubjectDescriptor theObjectDescriptor;
                    block6: {
                        block5: {
                            if (!this._instanceIdsToSubjectDescriptors.containsKey(aInstanceId)) break block7;
                            theObjectDescriptor = this._instanceIdsToSubjectDescriptors.remove(aInstanceId);
                            if (this._subjects.contains(theObjectDescriptor.getSubject())) break block5;
                            return null;
                        }
                        if (!this.hasSignedOffInstanceId(aInstanceId)) break block6;
                        return null;
                    }
                    this._subjects.remove(theObjectDescriptor.getSubject());
                    this.addSignedOffInstanceId(aInstanceId);
                    return theObjectDescriptor;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearSubjectDescriptos() {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                this._instanceIdsToSubjectDescriptors.clear();
                this._subjects.clear();
            }
        }

        Reply removeReplyDescriptor(String aInstanceId) {
            if (!this.hasMethodReplyDescriptor(aInstanceId)) {
                return null;
            }
            if (this.hasSignedOffInstanceId(aInstanceId)) {
                return null;
            }
            return this._instanceIdToMethodReplyDescriptor.remove(aInstanceId);
        }

        int size() {
            return this._subjects.size();
        }

        private void clearReplyDescriptors() {
            this._instanceIdToMethodReplyDescriptor.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearSignedOffInstanceIds() {
            InstanceHandler instanceHandler = this;
            synchronized (instanceHandler) {
                this._signedOffInstanceIds.clear();
            }
        }

        public synchronized boolean isBusy() {
            return !this._instanceIdToMethodReplyDescriptor.isEmpty();
        }
    }

    private class MethodInvokationDaemon
    implements Runnable {
        private Object[] _argumentArray;
        private boolean _hasResult = false;
        private Method _method;
        private Object _providedObject;
        private Throwable _returnThrowable = null;
        private Object _returnValue = null;

        MethodInvokationDaemon(Object aSubject, String aMethodName, Object[] anArgumentArray, Class<?>[] aParameterArray) throws IllegalArgumentException, NoSuchMethodException {
            this._method = aSubject.getClass().getMethod(aMethodName, aParameterArray);
            this._providedObject = aSubject;
            this._argumentArray = anArgumentArray;
            if (this._argumentArray != null) {
                int i = 0;
                while (i < this._argumentArray.length) {
                    this._argumentArray[i] = SerializeUtility.toSerializable(this._argumentArray[i]);
                    ++i;
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        Object getReturnValue() {
            return this._returnValue;
        }

        Throwable getException() {
            return this._returnThrowable;
        }

        boolean hasResult() {
            return this._hasResult;
        }
    }
}

