// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.remoting;

/**
 * This is a predictable exception. It is thrown by any object implementing the
 * GenericDisposeable interface. This exception can be avoided by first testing
 * the value returned by the method isDisposed() of the interface
 * GenericDisposeable.
 */
public class ProxyDisposedRuntimeException extends RemotingRuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new proxy disposed runtime exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public ProxyDisposedRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new proxy disposed runtime exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ProxyDisposedRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new proxy disposed runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ProxyDisposedRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new proxy disposed runtime exception.
	 *
	 * @param message the message
	 */
	public ProxyDisposedRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new proxy disposed runtime exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ProxyDisposedRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new proxy disposed runtime exception.
	 *
	 * @param cause the cause
	 */
	public ProxyDisposedRuntimeException( Throwable cause ) {
		super( cause );
	}
}
